/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.list.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.list.primitive.MutableIntList;

/**
 * A factory which creates instances of type {@link MutableIntList}.
 * This file was automatically generated from template file mutablePrimitiveListFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableIntListFactory
{
    MutableIntList empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableIntList of();

    /**
     * Same as {@link #empty()}.
     */
    MutableIntList with();

    /**
     * Same as {@link #with(int[])}.
     */
    MutableIntList of(int... items);

    MutableIntList with(int... items);

    /**
     * Same as {@link #withAll(IntIterable)}.
     */
    MutableIntList ofAll(IntIterable items);

    MutableIntList withAll(IntIterable items);
}
