/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ObjectLongPredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;

/**
 * This file was automatically generated from template file immutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableObjectLongMap<K> extends ObjectLongMap<K>
{
    ImmutableObjectLongMap<K> select(ObjectLongPredicate<? super K> predicate);

    ImmutableObjectLongMap<K> reject(ObjectLongPredicate<? super K> predicate);

    ImmutableLongCollection select(LongPredicate predicate);

    ImmutableLongCollection reject(LongPredicate predicate);

    <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function);

    ImmutableObjectLongMap<K> newWithKeyValue(K key, long value);

    ImmutableObjectLongMap<K> newWithoutKey(K key);

    ImmutableObjectLongMap<K> newWithoutAllKeys(Iterable<? extends K> keys);
}
