/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleShortPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleShortMap extends DoubleShortMap, MutableShortValuesMap
{
    void put(double key, short value);

    void putAll(DoubleShortMap map);

    void removeKey(double key);

    void remove(double key);

    short removeKeyIfAbsent(double key, short value);

    short getIfAbsentPut(double key, short value);

    short getIfAbsentPut(double key, ShortFunction0 function);

    short getIfAbsentPutWithKey(double key, DoubleToShortFunction function);

    <P> short getIfAbsentPutWith(double key, ShortFunction<? super P> function, P parameter);

    short updateValue(double key, short initialValueIfAbsent, ShortToShortFunction function);

    MutableDoubleShortMap select(DoubleShortPredicate predicate);

    MutableDoubleShortMap reject(DoubleShortPredicate predicate);

    MutableDoubleShortMap withKeyValue(double key, short value);

    MutableDoubleShortMap withoutKey(double key);

    MutableDoubleShortMap withoutAllKeys(DoubleIterable keys);

    MutableDoubleShortMap asUnmodifiable();

    MutableDoubleShortMap asSynchronized();


    short addToValue(double key, short toBeAdded);
}
