/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.predicate.primitive.IntBytePredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableIntByteMap extends IntByteMap, MutableByteValuesMap
{
    void put(int key, byte value);

    void putAll(IntByteMap map);

    void removeKey(int key);

    void remove(int key);

    byte removeKeyIfAbsent(int key, byte value);

    byte getIfAbsentPut(int key, byte value);

    byte getIfAbsentPut(int key, ByteFunction0 function);

    byte getIfAbsentPutWithKey(int key, IntToByteFunction function);

    <P> byte getIfAbsentPutWith(int key, ByteFunction<? super P> function, P parameter);

    byte updateValue(int key, byte initialValueIfAbsent, ByteToByteFunction function);

    MutableIntByteMap select(IntBytePredicate predicate);

    MutableIntByteMap reject(IntBytePredicate predicate);

    MutableIntByteMap withKeyValue(int key, byte value);

    MutableIntByteMap withoutKey(int key);

    MutableIntByteMap withoutAllKeys(IntIterable keys);

    MutableIntByteMap asUnmodifiable();

    MutableIntByteMap asSynchronized();


    byte addToValue(int key, byte toBeAdded);
}
