/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToCharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.predicate.primitive.ShortCharPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableShortCharMap extends ShortCharMap, MutableCharValuesMap
{
    void put(short key, char value);

    void putAll(ShortCharMap map);

    void removeKey(short key);

    void remove(short key);

    char removeKeyIfAbsent(short key, char value);

    char getIfAbsentPut(short key, char value);

    char getIfAbsentPut(short key, CharFunction0 function);

    char getIfAbsentPutWithKey(short key, ShortToCharFunction function);

    <P> char getIfAbsentPutWith(short key, CharFunction<? super P> function, P parameter);

    char updateValue(short key, char initialValueIfAbsent, CharToCharFunction function);

    MutableShortCharMap select(ShortCharPredicate predicate);

    MutableShortCharMap reject(ShortCharPredicate predicate);

    MutableShortCharMap withKeyValue(short key, char value);

    MutableShortCharMap withoutKey(short key);

    MutableShortCharMap withoutAllKeys(ShortIterable keys);

    MutableShortCharMap asUnmodifiable();

    MutableShortCharMap asSynchronized();


    char addToValue(short key, char toBeAdded);
}
