/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToIntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.predicate.primitive.ShortIntPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableShortIntMap extends ShortIntMap, MutableIntValuesMap
{
    void put(short key, int value);

    void putAll(ShortIntMap map);

    void removeKey(short key);

    void remove(short key);

    int removeKeyIfAbsent(short key, int value);

    int getIfAbsentPut(short key, int value);

    int getIfAbsentPut(short key, IntFunction0 function);

    int getIfAbsentPutWithKey(short key, ShortToIntFunction function);

    <P> int getIfAbsentPutWith(short key, IntFunction<? super P> function, P parameter);

    int updateValue(short key, int initialValueIfAbsent, IntToIntFunction function);

    MutableShortIntMap select(ShortIntPredicate predicate);

    MutableShortIntMap reject(ShortIntPredicate predicate);

    MutableShortIntMap withKeyValue(short key, int value);

    MutableShortIntMap withoutKey(short key);

    MutableShortIntMap withoutAllKeys(ShortIterable keys);

    MutableShortIntMap asUnmodifiable();

    MutableShortIntMap asSynchronized();


    int addToValue(short key, int toBeAdded);
}
