/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToLongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.predicate.primitive.ShortLongPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableShortLongMap extends ShortLongMap, MutableLongValuesMap
{
    void put(short key, long value);

    void putAll(ShortLongMap map);

    void removeKey(short key);

    void remove(short key);

    long removeKeyIfAbsent(short key, long value);

    long getIfAbsentPut(short key, long value);

    long getIfAbsentPut(short key, LongFunction0 function);

    long getIfAbsentPutWithKey(short key, ShortToLongFunction function);

    <P> long getIfAbsentPutWith(short key, LongFunction<? super P> function, P parameter);

    long updateValue(short key, long initialValueIfAbsent, LongToLongFunction function);

    MutableShortLongMap select(ShortLongPredicate predicate);

    MutableShortLongMap reject(ShortLongPredicate predicate);

    MutableShortLongMap withKeyValue(short key, long value);

    MutableShortLongMap withoutKey(short key);

    MutableShortLongMap withoutAllKeys(ShortIterable keys);

    MutableShortLongMap asUnmodifiable();

    MutableShortLongMap asSynchronized();


    long addToValue(short key, long toBeAdded);
}
