/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import java.util.Set;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.predicate.primitive.ObjectDoublePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.tuple.primitive.ObjectDoublePair;

/**
 * This file was automatically generated from template file objectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ObjectDoubleMap<K> extends DoubleIterable
{
    double get(Object key);

    double getOrThrow(Object key);

    double getIfAbsent(Object key, double ifAbsent);

    boolean containsKey(Object key);

    boolean containsValue(double value);

    void forEachValue(DoubleProcedure procedure);

    void forEachKey(Procedure<? super K> procedure);

    void forEachKeyValue(ObjectDoubleProcedure<? super K> procedure);

    ObjectDoubleMap<K> select(ObjectDoublePredicate<? super K> predicate);

    ObjectDoubleMap<K> reject(ObjectDoublePredicate<? super K> predicate);

    /**
     * Returns a string representation of this ObjectDoubleMap. The string representation consists of a list of the
     * map's key-value pairs in the order they are returned by its iterator. The key and value in each key-value pair are separated
     * by a colon (<tt>":"</tt>) and each pair is enclosed in square brackets (<tt>"[]"</tt>). Adjacent key-value pairs
     * are separated by the characters <tt>", "</tt> (comma and space). Keys and values are converted to strings as by
     * String#valueOf().
     *
     * @return a string representation of this ObjectDoubleMap
     */
    String toString();

    ImmutableObjectDoubleMap<K> toImmutable();

    Set<K> keySet();

    MutableDoubleCollection values();

    /**
     * @since 5.0
     */
    LazyIterable<K> keysView();

    /**
     * @since 5.0
     */
    RichIterable<ObjectDoublePair<K>> keyValuesView();
}
