/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.MutableIntObjectMap;
import com.gs.collections.api.map.primitive.IntObjectMap;

/**
 * A factory which creates instances of type {@link MutableIntObjectMap}.
 * This file was automatically generated from template file mutablePrimitiveObjectMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableIntObjectMapFactory
{
    <V> MutableIntObjectMap<V> empty();

    /**
     * Same as {@link #empty()}.
     */
    <V> MutableIntObjectMap<V> of();

    /**
     * Same as {@link #empty()}.
     */
    <V> MutableIntObjectMap<V> with();

    /**
     * Same as {@link #withAll(IntObjectMap)}.
     */
    <V> MutableIntObjectMap<V> ofAll(IntObjectMap<? extends V>  map);

    <V> MutableIntObjectMap<V> withAll(IntObjectMap<? extends V>  map);
}
