/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.stack.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.stack.primitive.ImmutableLongStack;

/**
 * A factory which creates instances of type {@link ImmutableLongStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableLongStackFactory
{
    /**
     * @since 6.0
     */
    ImmutableLongStack empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableLongStack of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableLongStack with();

    /**
     * Same as {@link #with(long)}.
     */
    ImmutableLongStack of(long one);

    ImmutableLongStack with(long one);

    /**
     * Same as {@link #with(long[])}.
     */
    ImmutableLongStack of(long... items);

    ImmutableLongStack with(long... items);

    /**
     * Same as {@link #withAll(LongIterable)}.
     */
    ImmutableLongStack ofAll(LongIterable items);

    ImmutableLongStack withAll(LongIterable items);

    /**
     * Same as {@link #withAllReversed(LongIterable)}.
     */
    ImmutableLongStack ofAllReversed(LongIterable items);

    ImmutableLongStack withAllReversed(LongIterable items);
}
