/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.stack.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.stack.primitive.MutableIntStack;

/**
 * A factory which creates instances of type {@link MutableIntStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableIntStackFactory
{
    MutableIntStack empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableIntStack of();

    /**
     * Same as {@link #empty()}.
     */
    MutableIntStack with();

    /**
     * Same as {@link #with(int[])}.
     */
    MutableIntStack of(int... items);

    MutableIntStack with(int... items);

    /**
     * Same as {@link #withAll(IntIterable)}.
     */
    MutableIntStack ofAll(IntIterable items);

    MutableIntStack withAll(IntIterable items);

    /**
     * Same as {@link #withAllReversed(IntIterable)}.
     */
    MutableIntStack ofAllReversed(IntIterable items);

    MutableIntStack withAllReversed(IntIterable items);
}
