/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import java.util.Map;

import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.predicate.primitive.DoubleDoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.DoubleDoublePair;

/**
 * This file was automatically generated from template file primitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface DoubleDoubleMap extends DoubleValuesMap
{
    double get(double key);

    double getIfAbsent(double key, double ifAbsent);

    double getOrThrow(double key);

    boolean containsKey(double key);

    void forEachKey(DoubleProcedure procedure);

    void forEachKeyValue(DoubleDoubleProcedure procedure);

    LazyDoubleIterable keysView();

    /**
     * @since 5.0
     */
    RichIterable<DoubleDoublePair> keyValuesView();

    DoubleDoubleMap select(DoubleDoublePredicate predicate);

    DoubleDoubleMap reject(DoubleDoublePredicate predicate);

    /**
     * Follows the same general contract as {@link Map#equals(Object)}.
     */
    @Override
    boolean equals(Object o);

    /**
     * Follows the same general contract as {@link Map#hashCode()}.
     */
    @Override
    int hashCode();

    /**
     * Returns a string representation of this DoubleDoubleMap. The string representation consists of a list of the
     * map's key-value pairs in the order they are returned by its iterator. The key and value in each key-value pair are separated
     * by a colon (<tt>":"</tt>) and each pair is enclosed in square brackets (<tt>"[]"</tt>). Adjacent key-value pairs
     * are separated by the characters <tt>", "</tt> (comma and space). Keys and values are converted to strings as by
     * String#valueOf().
     *
     * @return a string representation of this DoubleDoubleMap
     */
    String toString();

    ImmutableDoubleDoubleMap toImmutable();

    MutableDoubleSet keySet();
}
