/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.CharToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.predicate.primitive.CharDoublePredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableCharDoubleMap extends CharDoubleMap, MutableDoubleValuesMap
{
    void put(char key, double value);

    void putAll(CharDoubleMap map);

    void removeKey(char key);

    void remove(char key);

    double removeKeyIfAbsent(char key, double value);

    double getIfAbsentPut(char key, double value);

    double getIfAbsentPut(char key, DoubleFunction0 function);

    double getIfAbsentPutWithKey(char key, CharToDoubleFunction function);

    <P> double getIfAbsentPutWith(char key, DoubleFunction<? super P> function, P parameter);

    double updateValue(char key, double initialValueIfAbsent, DoubleToDoubleFunction function);

    MutableCharDoubleMap select(CharDoublePredicate predicate);

    MutableCharDoubleMap reject(CharDoublePredicate predicate);

    MutableCharDoubleMap withKeyValue(char key, double value);

    MutableCharDoubleMap withoutKey(char key);

    MutableCharDoubleMap withoutAllKeys(CharIterable keys);

    MutableCharDoubleMap asUnmodifiable();

    MutableCharDoubleMap asSynchronized();


    double addToValue(char key, double toBeAdded);
}
