/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleObjectPredicate;

/**
 * This file was automatically generated from template file mutablePrimitiveObjectMap.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleObjectMap<V> extends DoubleObjectMap<V>, MutablePrimitiveObjectMap<V>
{
    V put(double key, V value);

    /**
     * @since 5.0.
     */
    void putAll(DoubleObjectMap<? extends V> map);

    V removeKey(double key);

    V remove(double key);

    V getIfAbsentPut(double key, V value);

    V getIfAbsentPut(double key, Function0<? extends V> function);

    V getIfAbsentPutWithKey(double key, DoubleToObjectFunction<? extends V> function);

    <P> V getIfAbsentPutWith(double key, Function<? super P, ? extends V> function, P parameter);

    /**
     * Look up the value associated with {@code key}, apply the {@code function} to it, and replace the value. If there
     * is no value associated with {@code key}, start it off with a value supplied by {@code factory}.
     */
    V updateValue(double key, Function0<? extends V> factory, Function<? super V, ? extends V> function);

    /**
     * Same as {@link #updateValue(double, Function0, Function)} with a Function2 and specified parameter which is
     * passed to the function.
     */
    <P> V updateValueWith(double key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter);

    MutableDoubleObjectMap<V> select(DoubleObjectPredicate<? super V> predicate);

    MutableDoubleObjectMap<V> reject(DoubleObjectPredicate<? super V> predicate);

    MutableDoubleObjectMap<V> withKeyValue(double key, V value);

    MutableDoubleObjectMap<V> withoutKey(double key);

    MutableDoubleObjectMap<V> withoutAllKeys(DoubleIterable keys);

    MutableDoubleObjectMap<V> asUnmodifiable();

    MutableDoubleObjectMap<V> asSynchronized();
}
