/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToCharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.predicate.primitive.IntCharPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableIntCharMap extends IntCharMap, MutableCharValuesMap
{
    void put(int key, char value);

    void putAll(IntCharMap map);

    void removeKey(int key);

    void remove(int key);

    char removeKeyIfAbsent(int key, char value);

    char getIfAbsentPut(int key, char value);

    char getIfAbsentPut(int key, CharFunction0 function);

    char getIfAbsentPutWithKey(int key, IntToCharFunction function);

    <P> char getIfAbsentPutWith(int key, CharFunction<? super P> function, P parameter);

    char updateValue(int key, char initialValueIfAbsent, CharToCharFunction function);

    MutableIntCharMap select(IntCharPredicate predicate);

    MutableIntCharMap reject(IntCharPredicate predicate);

    MutableIntCharMap withKeyValue(int key, char value);

    MutableIntCharMap withoutKey(int key);

    MutableIntCharMap withoutAllKeys(IntIterable keys);

    MutableIntCharMap asUnmodifiable();

    MutableIntCharMap asSynchronized();


    char addToValue(int key, char toBeAdded);
}
