/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.IntShortPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableIntShortMap extends IntShortMap, MutableShortValuesMap
{
    void put(int key, short value);

    void putAll(IntShortMap map);

    void removeKey(int key);

    void remove(int key);

    short removeKeyIfAbsent(int key, short value);

    short getIfAbsentPut(int key, short value);

    short getIfAbsentPut(int key, ShortFunction0 function);

    short getIfAbsentPutWithKey(int key, IntToShortFunction function);

    <P> short getIfAbsentPutWith(int key, ShortFunction<? super P> function, P parameter);

    short updateValue(int key, short initialValueIfAbsent, ShortToShortFunction function);

    MutableIntShortMap select(IntShortPredicate predicate);

    MutableIntShortMap reject(IntShortPredicate predicate);

    MutableIntShortMap withKeyValue(int key, short value);

    MutableIntShortMap withoutKey(int key);

    MutableIntShortMap withoutAllKeys(IntIterable keys);

    MutableIntShortMap asUnmodifiable();

    MutableIntShortMap asSynchronized();


    short addToValue(int key, short toBeAdded);
}
