/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.set.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.set.ImmutableSet;

/**
 * This file was automatically generated from template file immutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface ImmutableDoubleSet extends ImmutableDoubleCollection, DoubleSet
{
    ImmutableDoubleSet select(DoublePredicate predicate);

    ImmutableDoubleSet reject(DoublePredicate predicate);

    <V> ImmutableSet<V> collect(DoubleToObjectFunction<? extends V> function);

    ImmutableDoubleSet newWith(double element);

    ImmutableDoubleSet newWithout(double element);

    ImmutableDoubleSet newWithAll(DoubleIterable elements);

    ImmutableDoubleSet newWithoutAll(DoubleIterable elements);
}
