/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.set.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableLongSet extends MutableLongCollection, LongSet
{
    MutableLongSet select(LongPredicate predicate);

    MutableLongSet reject(LongPredicate predicate);

    <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function);

    MutableLongSet with(long element);

    MutableLongSet without(long element);

    MutableLongSet withAll(LongIterable elements);

    MutableLongSet withoutAll(LongIterable elements);

    MutableLongSet asUnmodifiable();

    MutableLongSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    LongSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableLongSet toImmutable();
}
