/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.factory.bag.primitive.MutableByteBagFactory;
import com.gs.collections.api.bag.primitive.MutableByteBag;

/**
 * MutableByteBagFactoryImpl is a factory implementation which creates instances of type {@link MutableByteBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableByteBagFactoryImpl implements MutableByteBagFactory
{
    public MutableByteBag empty()
    {
        return new ByteHashBag();
    }

    public MutableByteBag of()
    {
        return this.empty();
    }

    public MutableByteBag with()
    {
        return this.empty();
    }

    public MutableByteBag of(byte... items)
    {
        return this.with(items);
    }

    public MutableByteBag with(byte... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return ByteHashBag.newBagWith(items);
    }

    public MutableByteBag ofAll(ByteIterable items)
    {
        return this.withAll(items);
    }

    public MutableByteBag withAll(ByteIterable items)
    {
        return ByteHashBag.newBag(items);
    }
}
