/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.bag.primitive.MutableDoubleBagFactory;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;

/**
 * MutableDoubleBagFactoryImpl is a factory implementation which creates instances of type {@link MutableDoubleBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableDoubleBagFactoryImpl implements MutableDoubleBagFactory
{
    public MutableDoubleBag empty()
    {
        return new DoubleHashBag();
    }

    public MutableDoubleBag of()
    {
        return this.empty();
    }

    public MutableDoubleBag with()
    {
        return this.empty();
    }

    public MutableDoubleBag of(double... items)
    {
        return this.with(items);
    }

    public MutableDoubleBag with(double... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return DoubleHashBag.newBagWith(items);
    }

    public MutableDoubleBag ofAll(DoubleIterable items)
    {
        return this.withAll(items);
    }

    public MutableDoubleBag withAll(DoubleIterable items)
    {
        return DoubleHashBag.newBag(items);
    }
}
