/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.collection.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.MutableShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import net.jcip.annotations.ThreadSafe;

/**
 * This file was automatically generated from template file abstractUnmodifiablePrimitiveCollection.stg.
 *
 * @since 3.1.
 */
@ThreadSafe
public abstract class AbstractUnmodifiableShortCollection
        implements MutableShortCollection, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableShortCollection collection;

    protected AbstractUnmodifiableShortCollection(MutableShortCollection collection)
    {
        this.collection = collection;
    }

    protected MutableShortCollection getShortCollection()
    {
        return this.collection;
    }

    public int size()
    {
        return this.collection.size();
    }

    public boolean isEmpty()
    {
        return this.collection.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.collection.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(short value)
    {
        return this.collection.contains(value);
    }

    public boolean containsAll(short... source)
    {
        return this.collection.containsAll(source);
    }

    public boolean containsAll(ShortIterable source)
    {
        return this.collection.containsAll(source);
    }

    public boolean add(short newItem)
    {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(short... source)
    {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(ShortIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean remove(short value)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(ShortIterable source)
    {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(short... source)
    {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(ShortIterable source)
    {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(short... source)
    {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public MutableShortIterator shortIterator()
    {
        return new UnmodifiableShortIterator(this.collection.shortIterator());
    }

    public void forEach(ShortProcedure procedure)
    {
        this.collection.forEach(procedure);
    }

    public int count(ShortPredicate predicate)
    {
        return this.collection.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return this.collection.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return this.collection.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return this.collection.noneSatisfy(predicate);
    }

    public MutableShortCollection select(ShortPredicate predicate)
    {
        return this.collection.select(predicate);
    }

    public MutableShortCollection reject(ShortPredicate predicate)
    {
        return this.collection.reject(predicate);
    }

    public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return this.collection.collect(function);
    }

    public MutableShortCollection with(short element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableShortCollection without(short element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableShortCollection withAll(ShortIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableShortCollection withoutAll(ShortIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableShortCollection asUnmodifiable()
    {
        return this;
    }

    public MutableShortCollection asSynchronized()
    {
        return new SynchronizedShortCollection(this);
    }

    public ImmutableShortCollection toImmutable()
    {
        return this.collection.toImmutable();
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    public long sum()
    {
        return this.collection.sum();
    }

    public short max()
    {
        return this.collection.max();
    }

    public short min()
    {
        return this.collection.min();
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.collection.minIfEmpty(defaultValue);
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.collection.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.collection.average();
    }

    public double median()
    {
        return this.collection.median();
    }

    public MutableShortList toSortedList()
    {
        return this.collection.toSortedList();
    }

    public short[] toSortedArray()
    {
        return this.collection.toSortedArray();
    }

    public short[] toArray()
    {
        return this.collection.toArray();
    }

    @Override
    public String toString()
    {
        return this.collection.toString();
    }

    public String makeString()
    {
        return this.collection.makeString();
    }

    public String makeString(String separator)
    {
        return this.collection.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.collection.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.collection.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.collection.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.collection.appendString(appendable, start, separator, end);
    }

    public MutableShortList toList()
    {
        return this.collection.toList();
    }

    public MutableShortSet toSet()
    {
        return this.collection.toSet();
    }

    public MutableShortBag toBag()
    {
        return this.collection.toBag();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return this.collection.injectInto(injectedValue, function);
    }
}
