/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.collection.mutable.primitive;

import com.gs.collections.api.collection.primitive.MutableIntCollection;
import net.jcip.annotations.ThreadSafe;

/**
 * This file was automatically generated from template file synchronizedPrimitiveCollection.stg.
 *
 * @since 4.0.
 */
@ThreadSafe
public class SynchronizedIntCollection
        extends AbstractSynchronizedIntCollection
{
    private static final long serialVersionUID = 1L;

    protected SynchronizedIntCollection(MutableIntCollection collection)
    {
        this(collection, null);
    }

    protected SynchronizedIntCollection(MutableIntCollection collection, Object newLock)
    {
        super(collection, newLock);
    }

    /**
     * This method will take a MutableIntCollection and wrap it directly in a SynchronizedIntCollection.
     */
    public static SynchronizedIntCollection of(MutableIntCollection collection)
    {
        return new SynchronizedIntCollection(collection);
    }

    /**
     * This method will take a MutableIntCollection and wrap it directly in a SynchronizedIntCollection.
     * Additionally, a developer specifies which lock to use with the collection.
     */
    public static SynchronizedIntCollection of(MutableIntCollection collection, Object lock)
    {
        return new SynchronizedIntCollection(collection, lock);
    }
}
