/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.ImmutableDoubleList;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseDoubleIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableDoubleSingletonList is an optimization for {@link ImmutableDoubleList} of size 1.
 * This file was automatically generated from template file immutablePrimitiveSingletonList.stg.
 */
@Immutable
final class ImmutableDoubleSingletonList implements ImmutableDoubleList, Serializable
{
    private static final long serialVersionUID = 1L;
    private final double element1;

    ImmutableDoubleSingletonList(double element)
    {
        this.element1 = element;
    }

    public double get(int index)
    {
        if (index == 0)
        {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    public double getFirst()
    {
        return this.element1;
    }

    public double getLast()
    {
        return this.element1;
    }

    public int indexOf(double value)
    {
        return Double.compare(this.element1, value) == 0 ? 0 : -1;
    }

    public int lastIndexOf(double value)
    {
        return Double.compare(this.element1, value) == 0 ? 0 : -1;
    }

    public DoubleIterator doubleIterator()
    {
        return new UnmodifiableDoubleIterator(DoubleArrayList.newListWith(this.element1).doubleIterator());
    }

    public void forEach(DoubleProcedure procedure)
    {
        procedure.value(this.element1);
    }

    public void forEachWithIndex(DoubleIntProcedure procedure)
    {
        procedure.value(this.element1, 0);
    }

    public int count(DoublePredicate predicate)
    {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return !predicate.accept(this.element1);
    }

    public ImmutableDoubleList select(DoublePredicate predicate)
    {
        return predicate.accept(this.element1) ? DoubleArrayList.newListWith(this.element1).toImmutable()
                : new DoubleArrayList().toImmutable();
    }

    public ImmutableDoubleList reject(DoublePredicate predicate)
    {
        return predicate.accept(this.element1) ? new DoubleArrayList().toImmutable()
                : DoubleArrayList.newListWith(this.element1).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableList<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    public double sum()
    {
        return this.element1;
    }

    public double max()
    {
        return this.element1;
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.element1;
    }

    public double min()
    {
        return this.element1;
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.element1;
    }

    public double average()
    {
        return this.element1;
    }

    public double median()
    {
        return this.element1;
    }

    public double[] toSortedArray()
    {
        return new double[]{this.element1};
    }

    public MutableDoubleList toSortedList()
    {
        return DoubleArrayList.newListWith(this.element1);
    }

    public double dotProduct(DoubleList list)
    {
        if (list.size() != 1)
        {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return this.element1 * list.getFirst();
    }

    public double[] toArray()
    {
        return new double[]{this.element1};
    }

    public boolean contains(double value)
    {
        return Double.compare(this.element1, value) == 0;
    }

    public boolean containsAll(double... source)
    {
        for (double value : source)
        {
            if (Double.compare(this.element1, value) != 0)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source)
    {
        for (DoubleIterator iterator = source.doubleIterator(); iterator.hasNext(); )
        {
            if (Double.compare(this.element1, iterator.next()) != 0)
            {
                return false;
            }
        }
        return true;
    }

    public LazyDoubleIterable asReversed()
    {
        return ReverseDoubleIterable.adapt(this);
    }

    public MutableDoubleList toList()
    {
        return DoubleArrayList.newListWith(this.element1);
    }

    public MutableDoubleSet toSet()
    {
        return DoubleHashSet.newSetWith(this.element1);
    }

    public MutableDoubleBag toBag()
    {
        return DoubleHashBag.newBagWith(this.element1);
    }

    public LazyDoubleIterable asLazy()
    {
        return new LazyDoubleIterableAdapter(this);
    }

    public ImmutableDoubleList toImmutable()
    {
        return this;
    }

    public ImmutableDoubleSingletonList toReversed()
    {
        return this;
    }

    public ImmutableDoubleList newWith(double element)
    {
        return DoubleLists.immutable.with(this.element1, element);
    }

    public ImmutableDoubleList newWithout(double element)
    {
        return Double.compare(this.element1, element) == 0 ? DoubleLists.immutable.with() : this;
    }

    public ImmutableDoubleList newWithAll(DoubleIterable elements)
    {
        DoubleArrayList arrayList = DoubleArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    public ImmutableDoubleList newWithoutAll(DoubleIterable elements)
    {
        return elements.contains(this.element1) ? DoubleLists.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectDoubleIntToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1, 0);
    }

    @Override
    public boolean equals(Object otherList)
    {
        if (otherList == this)
        {
            return true;
        }
        if (!(otherList instanceof DoubleList))
        {
            return false;
        }
        DoubleList list = (DoubleList) otherList;
        if (list.size() != 1)
        {
            return false;
        }
        return Double.compare(this.element1, list.get(0)) == 0;
    }

    @Override
    public int hashCode()
    {
        return 31 + (int) (Double.doubleToLongBits(this.element1) ^ Double.doubleToLongBits(this.element1) >>> 32);
    }

    @Override
    public String toString()
    {
        return "[" + this.element1 + ']';
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    /**
     * @since 6.0.
     */
    public ImmutableDoubleList distinct()
    {
        return this;
    }

    public ImmutableDoubleList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
