/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongIntPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.LongIntProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.LongIntMap;
import com.gs.collections.api.map.primitive.ImmutableLongIntMap;
import com.gs.collections.api.map.primitive.MutableLongIntMap;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.LongIntPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedLongIntProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.iterator.UnmodifiableIntIterator;
import com.gs.collections.impl.map.mutable.primitive.LongIntHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;

/**
 * ImmutableLongIntHashMap is the non-modifiable equivalent of {@link LongIntHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableLongIntHashMap implements ImmutableLongIntMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableLongIntMap delegate;

    ImmutableLongIntHashMap(LongIntMap delegate)
    {
        this.delegate = new LongIntHashMap(delegate);
    }

    public int get(long key)
    {
        return this.delegate.get(key);
    }

    public int getIfAbsent(long key, int ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public int getOrThrow(long key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(long key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(int value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongIntProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<LongIntPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableLongIntMap select(LongIntPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongIntMap reject(LongIntPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableLongIntMap toImmutable()
    {
        return this;
    }

    public IntIterator intIterator()
    {
        return new UnmodifiableIntIterator(this.delegate.intIterator());
    }

    public void forEach(IntProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(IntPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableIntCollection select(IntPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntCollection reject(IntPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public int max()
    {
        return this.delegate.max();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public int min()
    {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public int[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableIntList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public int[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(int value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(int... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(IntIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableIntList toList()
    {
        return this.delegate.toList();
    }

    public MutableIntSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableIntBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyIntIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableLongIntMap newWithKeyValue(long key, int value)
    {
        MutableLongIntMap map = new LongIntHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongIntMap newWithoutKey(long key)
    {
        MutableLongIntMap map = new LongIntHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongIntMap newWithoutAllKeys(LongIterable keys)
    {
        MutableLongIntMap map = new LongIntHashMap(this.size());
        map.putAll(this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableLongSet keySet()
    {
        return UnmodifiableLongSet.of(this.delegate.keySet());
    }

    public MutableIntCollection values()
    {
        return UnmodifiableIntCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableLongIntMapSerializationProxy(this);
    }

    protected static class ImmutableLongIntMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private LongIntMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableLongIntMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableLongIntMapSerializationProxy(LongIntMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedLongIntProcedure()
                {
                    @Override
                    public void safeValue(long key, int value) throws IOException
                    {
                        out.writeLong(key);
                        out.writeInt(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableLongIntMap deserializedMap = new LongIntHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readLong(), in.readInt());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
