/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.LongShortProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.LongShortMap;
import com.gs.collections.api.map.primitive.ImmutableLongShortMap;
import com.gs.collections.api.map.primitive.MutableLongShortMap;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.primitive.LongShortPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedLongShortProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.map.mutable.primitive.LongShortHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;

/**
 * ImmutableLongShortHashMap is the non-modifiable equivalent of {@link LongShortHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableLongShortHashMap implements ImmutableLongShortMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableLongShortMap delegate;

    ImmutableLongShortHashMap(LongShortMap delegate)
    {
        this.delegate = new LongShortHashMap(delegate);
    }

    public short get(long key)
    {
        return this.delegate.get(key);
    }

    public short getIfAbsent(long key, short ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public short getOrThrow(long key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(long key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(short value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongShortProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<LongShortPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableLongShortMap select(LongShortPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongShortMap reject(LongShortPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableLongShortMap toImmutable()
    {
        return this;
    }

    public ShortIterator shortIterator()
    {
        return new UnmodifiableShortIterator(this.delegate.shortIterator());
    }

    public void forEach(ShortProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(ShortPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableShortCollection select(ShortPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public short max()
    {
        return this.delegate.max();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public short min()
    {
        return this.delegate.min();
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public short[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableShortList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public short[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(short value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(short... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ShortIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableShortList toList()
    {
        return this.delegate.toList();
    }

    public MutableShortSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableShortBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyShortIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableLongShortMap newWithKeyValue(long key, short value)
    {
        MutableLongShortMap map = new LongShortHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongShortMap newWithoutKey(long key)
    {
        MutableLongShortMap map = new LongShortHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongShortMap newWithoutAllKeys(LongIterable keys)
    {
        MutableLongShortMap map = new LongShortHashMap(this.size());
        map.putAll(this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableLongSet keySet()
    {
        return UnmodifiableLongSet.of(this.delegate.keySet());
    }

    public MutableShortCollection values()
    {
        return UnmodifiableShortCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableLongShortMapSerializationProxy(this);
    }

    protected static class ImmutableLongShortMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private LongShortMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableLongShortMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableLongShortMapSerializationProxy(LongShortMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedLongShortProcedure()
                {
                    @Override
                    public void safeValue(long key, short value) throws IOException
                    {
                        out.writeLong(key);
                        out.writeShort(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableLongShortMap deserializedMap = new LongShortHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readLong(), in.readShort());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
