/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.util.NoSuchElementException;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.MutableIntValuesMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedIntCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.primitive.AbstractIntIterable;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;

/**
 * This file was automatically generated from template file abstractMutablePrimitiveValuesMap.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractMutableIntValuesMap extends AbstractIntIterable implements MutableIntValuesMap
{
    protected abstract int getOccupiedWithData();

    protected abstract SentinelValues getSentinelValues();

    protected abstract void setSentinelValuesNull();

    protected abstract int getEmptyValue();

    protected abstract int getValueAtIndex(int index);

    protected abstract int getTableSize();

    protected abstract boolean isNonSentinelAtIndex(int index);

    protected void addEmptyKeyValue(int value)
    {
        this.getSentinelValues().containsZeroKey = true;
        this.getSentinelValues().zeroValue = value;
    }

    protected void removeEmptyKey()
    {
        if (this.getSentinelValues().containsOneKey)
        {
            this.getSentinelValues().containsZeroKey = false;
            this.getSentinelValues().zeroValue = this.getEmptyValue();
        }
        else
        {
            this.setSentinelValuesNull();
        }
    }

    protected void addRemovedKeyValue(int value)
    {
        this.getSentinelValues().containsOneKey = true;
        this.getSentinelValues().oneValue = value;
    }

    protected void removeRemovedKey()
    {
        if (this.getSentinelValues().containsZeroKey)
        {
            this.getSentinelValues().containsOneKey = false;
            this.getSentinelValues().oneValue = this.getEmptyValue();
        }
        else
        {
            this.setSentinelValuesNull();
        }
    }

    public boolean contains(int value)
    {
        return this.containsValue(value);
    }

    @Override
    public boolean containsAll(IntIterable source)
    {
        return source.allSatisfy(new IntPredicate()
        {
            public boolean accept(int value)
            {
                return AbstractMutableIntValuesMap.this.contains(value);
            }
        });
    }

    public int max()
    {
        if (this.isEmpty())
        {
            throw new NoSuchElementException();
        }
        IntIterator iterator = this.intIterator();
        int max = iterator.next();
        while (iterator.hasNext())
        {
            int value = iterator.next();
            if (max < value)
            {
                max = value;
            }
        }
        return max;
    }

    public int min()
    {
        if (this.isEmpty())
        {
            throw new NoSuchElementException();
        }
        IntIterator iterator = this.intIterator();
        int min = iterator.next();
        while (iterator.hasNext())
        {
            int value = iterator.next();
            if (value < min)
            {
                min = value;
            }
        }
        return min;
    }

    public int size()
    {
        return this.getOccupiedWithData() + (this.getSentinelValues() == null ? 0 : this.getSentinelValues().size());
    }

    @Override
    public boolean isEmpty()
    {
        return this.getOccupiedWithData() == 0 && (this.getSentinelValues() == null || this.getSentinelValues().size() == 0);
    }

    @Override
    public boolean notEmpty()
    {
        return this.getOccupiedWithData() != 0 || (this.getSentinelValues() != null && this.getSentinelValues().size() != 0);
    }

    public void forEach(IntProcedure procedure)
    {
        this.forEachValue(procedure);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);

            boolean first = true;

            if (this.getSentinelValues() != null)
            {
                if (this.getSentinelValues().containsZeroKey)
                {
                    appendable.append(String.valueOf(this.getSentinelValues().zeroValue));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey)
                {
                    if (!first)
                    {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.getSentinelValues().oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); i++)
            {
                if (this.isNonSentinelAtIndex(i))
                {
                    if (!first)
                    {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.getValueAtIndex(i)));
                    first = false;
                }
            }
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public int[] toArray()
    {
        int[] array = new int[this.size()];
        int index = 0;

        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey)
            {
                array[index] = this.getSentinelValues().zeroValue;
                index++;
            }
            if (this.getSentinelValues().containsOneKey)
            {
                array[index] = this.getSentinelValues().oneValue;
                index++;
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i))
            {
                array[index] = this.getValueAtIndex(i);
                index++;
            }
        }

        return array;
    }

    public MutableIntCollection select(IntPredicate predicate)
    {
        IntArrayList result = new IntArrayList();

        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue))
            {
                result.add(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue))
            {
                result.add(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i) && predicate.accept(this.getValueAtIndex(i)))
            {
                result.add(this.getValueAtIndex(i));
            }
        }

        return result;
    }

    public MutableIntCollection reject(IntPredicate predicate)
    {
        IntArrayList result = new IntArrayList();
        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(this.getSentinelValues().zeroValue))
            {
                result.add(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(this.getSentinelValues().oneValue))
            {
                result.add(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i) && !predicate.accept(this.getValueAtIndex(i)))
            {
                result.add(this.getValueAtIndex(i));
            }
        }
        return result;
    }

    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function)
    {
        FastList<V> target = FastList.newList(this.size());
        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey)
            {
                target.add(function.valueOf(this.getSentinelValues().zeroValue));
            }
            if (this.getSentinelValues().containsOneKey)
            {
                target.add(function.valueOf(this.getSentinelValues().oneValue));
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i))
            {
                target.add(function.valueOf(this.getValueAtIndex(i)));
            }
        }
        return target;
    }

    public int detectIfNone(IntPredicate predicate, int value)
    {
        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue))
            {
                return this.getSentinelValues().zeroValue;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue))
            {
                return this.getSentinelValues().oneValue;
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i) && predicate.accept(this.getValueAtIndex(i)))
            {
                return this.getValueAtIndex(i);
            }
        }
        return value;
    }

    public int count(IntPredicate predicate)
    {
        int count = 0;
        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue))
            {
                count++;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue))
            {
                count++;
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i) && predicate.accept(this.getValueAtIndex(i)))
            {
                count++;
            }
        }
        return count;
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue))
            {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue))
            {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i) && predicate.accept(this.getValueAtIndex(i)))
            {
                return true;
            }
        }
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(this.getSentinelValues().zeroValue))
            {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(this.getSentinelValues().oneValue))
            {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i) && !predicate.accept(this.getValueAtIndex(i)))
            {
                return false;
            }
        }
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue))
            {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue))
            {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i) && predicate.accept(this.getValueAtIndex(i)))
            {
                return false;
            }
        }
        return true;
    }

    public long sum()
    {
        long result = 0L;

        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey)
            {
                result += this.getSentinelValues().zeroValue;
            }
            if (this.getSentinelValues().containsOneKey)
            {
                result += this.getSentinelValues().oneValue;
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i))
            {
                result += this.getValueAtIndex(i);
            }
        }

        return result;
    }

    public boolean containsValue(int value)
    {
        if (this.getSentinelValues() != null && this.getSentinelValues().containsValue(value))
        {
            return true;
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i) && this.getValueAtIndex(i) == value)
            {
                return true;
            }
        }
        return false;
    }

    public void forEachValue(IntProcedure procedure)
    {
        if (this.getSentinelValues() != null)
        {
            if (this.getSentinelValues().containsZeroKey)
            {
                procedure.value(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey)
            {
                procedure.value(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.getTableSize(); i++)
        {
            if (this.isNonSentinelAtIndex(i))
            {
                procedure.value(this.getValueAtIndex(i));
            }
        }
    }

    protected static class SentinelValues extends AbstractSentinelValues
    {
        protected int zeroValue;
        protected int oneValue;

        public boolean containsValue(int value)
        {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }

    protected abstract class AbstractIntValuesCollection implements MutableIntCollection
    {
        public void clear()
        {
            AbstractMutableIntValuesMap.this.clear();
        }

        public MutableIntCollection select(IntPredicate predicate)
        {
            return AbstractMutableIntValuesMap.this.select(predicate);
        }

        public MutableIntCollection reject(IntPredicate predicate)
        {
            return AbstractMutableIntValuesMap.this.reject(predicate);
        }

        public int detectIfNone(IntPredicate predicate, int ifNone)
        {
            return AbstractMutableIntValuesMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function)
        {
            return AbstractMutableIntValuesMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
        {
            return AbstractMutableIntValuesMap.this.injectInto(injectedValue, function);
        }

        public long sum()
        {
            return AbstractMutableIntValuesMap.this.sum();
        }

        public int max()
        {
            return AbstractMutableIntValuesMap.this.max();
        }

        public int maxIfEmpty(int defaultValue)
        {
            return AbstractMutableIntValuesMap.this.maxIfEmpty(defaultValue);
        }

        public int min()
        {
            return AbstractMutableIntValuesMap.this.min();
        }

        public int minIfEmpty(int defaultValue)
        {
            return AbstractMutableIntValuesMap.this.minIfEmpty(defaultValue);
        }

        public double average()
        {
            return AbstractMutableIntValuesMap.this.average();
        }

        public double median()
        {
            return AbstractMutableIntValuesMap.this.median();
        }

        public int[] toSortedArray()
        {
            return AbstractMutableIntValuesMap.this.toSortedArray();
        }

        public MutableIntList toSortedList()
        {
            return AbstractMutableIntValuesMap.this.toSortedList();
        }

        public MutableIntCollection with(int element)
        {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection without(int element)
        {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection withAll(IntIterable elements)
        {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection withoutAll(IntIterable elements)
        {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection asUnmodifiable()
        {
            return UnmodifiableIntCollection.of(this);
        }

        public MutableIntCollection asSynchronized()
        {
            return SynchronizedIntCollection.of(this);
        }

        public ImmutableIntCollection toImmutable()
        {
            return IntLists.immutable.withAll(this);
        }

        public boolean contains(int value)
        {
            return AbstractMutableIntValuesMap.this.containsValue(value);
        }

        public boolean containsAll(int... source)
        {
            return AbstractMutableIntValuesMap.this.containsAll(source);
        }

        public boolean containsAll(IntIterable source)
        {
            return AbstractMutableIntValuesMap.this.containsAll(source);
        }

        public MutableIntList toList()
        {
            return AbstractMutableIntValuesMap.this.toList();
        }

        public MutableIntSet toSet()
        {
            return AbstractMutableIntValuesMap.this.toSet();
        }

        public MutableIntBag toBag()
        {
            return AbstractMutableIntValuesMap.this.toBag();
        }

        public LazyIntIterable asLazy()
        {
            return new LazyIntIterableAdapter(this);
        }

        public boolean isEmpty()
        {
            return AbstractMutableIntValuesMap.this.isEmpty();
        }

        public boolean notEmpty()
        {
            return AbstractMutableIntValuesMap.this.notEmpty();
        }

        public String makeString()
        {
            return AbstractMutableIntValuesMap.this.makeString();
        }

        public String makeString(String separator)
        {
            return AbstractMutableIntValuesMap.this.makeString(separator);
        }

        public String makeString(String start, String separator, String end)
        {
            return AbstractMutableIntValuesMap.this.makeString(start, separator, end);
        }

        public void appendString(Appendable appendable)
        {
            AbstractMutableIntValuesMap.this.appendString(appendable);
        }

        public void appendString(Appendable appendable, String separator)
        {
            AbstractMutableIntValuesMap.this.appendString(appendable, separator);
        }

        public void appendString(Appendable appendable, String start, String separator, String end)
        {
            AbstractMutableIntValuesMap.this.appendString(appendable, start, separator, end);
        }

        public void forEach(IntProcedure procedure)
        {
            AbstractMutableIntValuesMap.this.forEach(procedure);
        }

        public int count(IntPredicate predicate)
        {
            return AbstractMutableIntValuesMap.this.count(predicate);
        }

        public boolean anySatisfy(IntPredicate predicate)
        {
            return AbstractMutableIntValuesMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(IntPredicate predicate)
        {
            return AbstractMutableIntValuesMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(IntPredicate predicate)
        {
            return AbstractMutableIntValuesMap.this.noneSatisfy(predicate);
        }

        public boolean add(int element)
        {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(int... source)
        {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(IntIterable source)
        {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean removeAll(IntIterable source)
        {
            int oldSize = AbstractMutableIntValuesMap.this.size();

            IntIterator iterator = source.intIterator();
            while (iterator.hasNext())
            {
                this.remove(iterator.next());
            }
            return oldSize != AbstractMutableIntValuesMap.this.size();
        }

        public boolean removeAll(int... source)
        {
            int oldSize = AbstractMutableIntValuesMap.this.size();

            for (int item : source)
            {
                this.remove(item);
            }
            return oldSize != AbstractMutableIntValuesMap.this.size();
        }

        public boolean retainAll(int... source)
        {
            return this.retainAll(IntHashSet.newSetWith(source));
        }

        public int size()
        {
            return AbstractMutableIntValuesMap.this.size();
        }

        public int[] toArray()
        {
            return AbstractMutableIntValuesMap.this.toArray();
        }
    }
}
