/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.factory.map.primitive.MutableObjectDoubleMapFactory;
import com.gs.collections.api.map.primitive.MutableObjectDoubleMap;
import com.gs.collections.api.map.primitive.ObjectDoubleMap;

/**
 * MutableObjectDoubleMapFactoryImpl is a factory implementation which creates instances of type {@link MutableObjectDoubleMap}.
 * This file was automatically generated from template file mutableObjectPrimitiveMapFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableObjectDoubleMapFactoryImpl implements MutableObjectDoubleMapFactory
{
    public <K> MutableObjectDoubleMap<K> empty()
    {
        return new ObjectDoubleHashMap(0);
    }

    public <K> MutableObjectDoubleMap<K> of()
    {
        return this.empty();
    }

    public <K> MutableObjectDoubleMap<K> with()
    {
        return this.empty();
    }

    public <K> MutableObjectDoubleMap<K> ofAll(ObjectDoubleMap<? extends K> map)
    {
        return this.withAll(map);
    }

    public <K> MutableObjectDoubleMap<K> withAll(ObjectDoubleMap<? extends K> map)
    {
        if (map.isEmpty())
        {
            return this.empty();
        }
        return new ObjectDoubleHashMap<K>(map);
    }
}
