/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedShortProcedure;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;

/**
 * This file was automatically generated from template file immutablePrimitiveSetSerializationProxy.stg.
 *
 * @since 4.0.
 */
public final class ImmutableShortSetSerializationProxy implements Externalizable
{
    private static final long serialVersionUID = 1L;

    private ShortSet set;

    @SuppressWarnings("UnusedDeclaration")
    public ImmutableShortSetSerializationProxy()
    {
        // Empty constructor for Externalizable class
    }

    public ImmutableShortSetSerializationProxy(ShortSet set)
    {
        this.set = set;
    }

    public void writeExternal(final ObjectOutput out) throws IOException
    {
        out.writeInt(this.set.size());
        try
        {
            this.set.forEach(new CheckedShortProcedure()
            {
                @Override
                public void safeValue(short item) throws Exception
                {
                    out.writeShort(item);
                }
            });
        }
        catch (RuntimeException e)
        {
            if (e.getCause() instanceof IOException)
            {
                throw (IOException) e.getCause();
            }
            throw e;
        }
    }

    public void readExternal(ObjectInput in) throws IOException
    {
        int size = in.readInt();
        MutableShortSet deserializedSet = new ShortHashSet(size);

        for (int i = 0; i < size; i++)
        {
            deserializedSet.add(in.readShort());
        }

        this.set = deserializedSet;
    }

    private Object readResolve()
    {
        return this.set.toImmutable();
    }
}
