/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable;

import com.gs.collections.api.bag.Bag;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.sorted.MutableSortedBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.bag.ImmutableBagMultimap;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.primitive.ObjectIntPair;
import com.gs.collections.impl.bag.immutable.AbstractImmutableBag;
import com.gs.collections.impl.bag.immutable.ImmutableBagSerializationProxy;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.sorted.mutable.TreeBag;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.factory.Predicates2;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.SortedSets;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.bag.HashBagMultimap;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.utility.ArrayIterate;
import com.gs.collections.impl.utility.Iterate;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableArrayBag<T>
extends AbstractImmutableBag<T>
implements Serializable {
    static final int MAXIMUM_USEFUL_ARRAY_BAG_SIZE = 20;
    private static final long serialVersionUID = 1L;
    private final T[] keys;
    private final int[] counts;

    ImmutableArrayBag(T[] keys, int[] counts) {
        this.keys = keys;
        this.counts = counts;
        if (this.keys.length != this.counts.length) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> ImmutableArrayBag<T> newBagWith(T ... elements) {
        return ImmutableArrayBag.copyFrom(Bags.mutable.with((Object[])elements));
    }

    public static <T> ImmutableArrayBag<T> copyFrom(Bag<T> bag) {
        int distinctItemCount = bag.sizeDistinct();
        final Object[] newKeys = new Object[distinctItemCount];
        final int[] newCounts = new int[distinctItemCount];
        bag.forEachWithOccurrences(new ObjectIntProcedure<T>(){
            private int index;

            public void value(T each, int count) {
                newKeys[this.index] = each;
                newCounts[this.index] = count;
                ++this.index;
            }
        });
        return new ImmutableArrayBag<Object>(newKeys, newCounts);
    }

    @Override
    public int size() {
        int sum = 0;
        for (int value : this.counts) {
            sum += value;
        }
        return sum;
    }

    public int sizeDistinct() {
        return this.keys.length;
    }

    public int occurrencesOf(Object item) {
        int index = ArrayIterate.detectIndexWith(this.keys, Predicates2.equal(), item);
        if (index > -1) {
            return this.counts[index];
        }
        return 0;
    }

    public void forEachWithOccurrences(ObjectIntProcedure<? super T> objectIntProcedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            objectIntProcedure.value(this.keys[i], this.counts[i]);
        }
    }

    public ImmutableBag<T> newWith(T element) {
        int elementIndex = ArrayIterate.detectIndexWith(this.keys, Predicates2.equal(), element);
        int distinctItemCount = this.sizeDistinct() + (elementIndex == -1 ? 1 : 0);
        if (distinctItemCount > 20) {
            return HashBag.newBag(this).with((Object)element).toImmutable();
        }
        return this.newArrayBagWith(element, elementIndex, distinctItemCount);
    }

    private ImmutableBag<T> newArrayBagWith(T element, int elementIndex, int distinctItemCount) {
        Object[] newKeys = new Object[distinctItemCount];
        int[] newCounts = new int[distinctItemCount];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.counts, 0, newCounts, 0, this.counts.length);
        if (elementIndex == -1) {
            newKeys[distinctItemCount - 1] = element;
            newCounts[distinctItemCount - 1] = 1;
        } else {
            int n = elementIndex;
            newCounts[n] = newCounts[n] + 1;
        }
        return new ImmutableArrayBag<Object>(newKeys, newCounts);
    }

    public ImmutableBag<T> newWithout(T element) {
        int elementIndex = ArrayIterate.detectIndexWith(this.keys, Predicates2.equal(), element);
        if (elementIndex > -1) {
            int distinctItemCount = this.sizeDistinct() - (this.counts[elementIndex] == 1 ? 1 : 0);
            Object[] newKeys = new Object[distinctItemCount];
            int[] newCounts = new int[distinctItemCount];
            if (distinctItemCount == this.sizeDistinct()) {
                System.arraycopy(this.keys, 0, newKeys, 0, distinctItemCount);
                System.arraycopy(this.counts, 0, newCounts, 0, distinctItemCount);
                int n = elementIndex;
                newCounts[n] = newCounts[n] - 1;
            } else {
                System.arraycopy(this.keys, 0, newKeys, 0, elementIndex);
                System.arraycopy(this.counts, 0, newCounts, 0, elementIndex);
                System.arraycopy(this.keys, elementIndex + 1, newKeys, elementIndex, newKeys.length - elementIndex);
                System.arraycopy(this.counts, elementIndex + 1, newCounts, elementIndex, newCounts.length - elementIndex);
            }
            return new ImmutableArrayBag<Object>(newKeys, newCounts);
        }
        return this;
    }

    @Override
    public MutableList<T> toList() {
        final FastList result = FastList.newList(this.size());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    result.add(each);
                }
            }
        });
        return result;
    }

    @Override
    public MutableList<T> toSortedList(final Comparator<? super T> comparator) {
        MutableList sorted = this.toListWithOccurrences().sortThis(new Comparator<ObjectIntPair<T>>(){

            @Override
            public int compare(ObjectIntPair<T> o1, ObjectIntPair<T> o2) {
                return comparator.compare(o1.getOne(), o2.getOne());
            }
        });
        final FastList result = FastList.newList(this.size());
        sorted.forEach(new Procedure<ObjectIntPair<T>>(){

            public void value(ObjectIntPair<T> each) {
                Object object = each.getOne();
                int occurrences = each.getTwo();
                for (int i = 0; i < occurrences; ++i) {
                    result.add(object);
                }
            }
        });
        return result;
    }

    @Override
    public MutableSet<T> toSet() {
        final MutableSet result = Sets.mutable.empty();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.add(each);
            }
        });
        return result;
    }

    @Override
    public MutableSortedSet<T> toSortedSet() {
        final MutableSortedSet result = SortedSets.mutable.empty();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.add(each);
            }
        });
        return result;
    }

    @Override
    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        final MutableSortedSet result = SortedSets.mutable.with(comparator);
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.add(each);
            }
        });
        return result;
    }

    @Override
    public MutableBag<T> toBag() {
        final HashBag result = HashBag.newBag(this.sizeDistinct());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    @Override
    public MutableSortedBag<T> toSortedBag() {
        final TreeBag result = TreeBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    @Override
    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        final TreeBag<? super T> result = TreeBag.newBag(comparator);
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public MutableMap<T, Integer> toMapOfItemToCount() {
        final UnifiedMap map = UnifiedMap.newMap(this.size());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T item, int count) {
                map.put(item, (Object)count);
            }
        });
        return map;
    }

    public ImmutableBag<T> toImmutable() {
        return this;
    }

    public ImmutableBag<T> newWithAll(Iterable<? extends T> elements) {
        return Bags.immutable.withAll(Iterate.addAllTo(elements, HashBag.newBag(this)));
    }

    public ImmutableBag<T> newWithoutAll(Iterable<? extends T> elements) {
        return this.reject((Predicate<? super T>)Predicates.in(elements));
    }

    public ImmutableBag<T> selectByOccurrences(final IntPredicate predicate) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(occurrences)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result.toImmutable();
    }

    public ImmutableBag<T> select(final Predicate<? super T> predicate) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result.toImmutable();
    }

    public ImmutableBag<T> reject(final Predicate<? super T> predicate) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (!predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result.toImmutable();
    }

    public <S> ImmutableBag<S> selectInstancesOf(final Class<S> clazz) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                if (clazz.isInstance(each)) {
                    result.addOccurrences(each, index);
                }
            }
        });
        return ImmutableArrayBag.copyFrom(result);
    }

    public <V> ImmutableBag<V> collect(final Function<? super T, ? extends V> function) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                result.addOccurrences(function.valueOf(each), index);
            }
        });
        return ImmutableArrayBag.copyFrom(result);
    }

    public <V> ImmutableBag<V> collectIf(final Predicate<? super T> predicate, final Function<? super T, ? extends V> function) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(each)) {
                    result.addOccurrences(function.valueOf(each), occurrences);
                }
            }
        });
        return ImmutableArrayBag.copyFrom(result);
    }

    public <V> ImmutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, HashBagMultimap.newMultimap()).toImmutable();
    }

    public <V> ImmutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, HashBagMultimap.newMultimap()).toImmutable();
    }

    public T getFirst() {
        return ArrayIterate.getFirst(this.keys);
    }

    public T getLast() {
        return ArrayIterate.getLast(this.keys);
    }

    public <V> ImmutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        HashBag result = HashBag.newBag();
        this.flatCollect(function, result);
        return result.toImmutable();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bag)) {
            return false;
        }
        Bag bag = (Bag)other;
        if (this.size() != bag.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.counts[i] == bag.occurrencesOf(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int sum = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            T each = this.keys[i];
            sum += (each == null ? 0 : each.hashCode()) ^ this.counts[i];
        }
        return sum;
    }

    public void each(Procedure<? super T> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            T key = this.keys[i];
            for (int j = 1; j <= this.counts[i]; ++j) {
                procedure.value(key);
            }
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayBagIterator();
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return ArrayIterate.anySatisfy(this.keys, predicate);
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ArrayIterate.anySatisfyWith(this.keys, predicate, parameter);
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return ArrayIterate.allSatisfy(this.keys, predicate);
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ArrayIterate.allSatisfyWith(this.keys, predicate, parameter);
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return ArrayIterate.noneSatisfy(this.keys, predicate);
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ArrayIterate.noneSatisfyWith(this.keys, predicate, parameter);
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return ArrayIterate.detect(this.keys, predicate);
    }

    @Override
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ArrayIterate.detectWith(this.keys, predicate, parameter);
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        return ArrayIterate.min(this.keys, comparator);
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        return ArrayIterate.max(this.keys, comparator);
    }

    @Override
    public T min() {
        return ArrayIterate.min(this.keys);
    }

    @Override
    public T max() {
        return ArrayIterate.max(this.keys);
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        return ArrayIterate.minBy(this.keys, function);
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        return ArrayIterate.maxBy(this.keys, function);
    }

    @Deprecated
    public <S> ImmutableBag<Pair<T, S>> zip(Iterable<S> that) {
        return this.zip(that, HashBag.newBag()).toImmutable();
    }

    @Deprecated
    public ImmutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(UnifiedSet.newSet()).toImmutable();
    }

    protected Object writeReplace() {
        return new ImmutableBagSerializationProxy(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ArrayBagIterator
    implements Iterator<T> {
        private int position;
        private int remainingOccurrences = -1;

        private ArrayBagIterator() {
            this.remainingOccurrences = ImmutableArrayBag.this.sizeDistinct() > 0 ? ImmutableArrayBag.this.counts[0] : 0;
        }

        @Override
        public boolean hasNext() {
            return this.position != ImmutableArrayBag.this.keys.length && (this.position != ImmutableArrayBag.this.keys.length - 1 || this.remainingOccurrences != 0);
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = ImmutableArrayBag.this.keys[this.position];
            --this.remainingOccurrences;
            if (this.remainingOccurrences == 0) {
                ++this.position;
                if (this.position != ImmutableArrayBag.this.keys.length) {
                    this.remainingOccurrences = ImmutableArrayBag.this.counts[this.position];
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from an ImmutableArrayBag");
        }
    }
}

