/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatCharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatCharProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.FloatCharMap;
import com.gs.collections.api.map.primitive.ImmutableFloatCharMap;
import com.gs.collections.api.map.primitive.MutableFloatCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.FloatCharPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedFloatCharProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.map.mutable.primitive.FloatCharHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableFloatCharHashMap
implements ImmutableFloatCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableFloatCharMap delegate;

    ImmutableFloatCharHashMap(FloatCharMap delegate) {
        this.delegate = new FloatCharHashMap(delegate);
    }

    public char get(float key) {
        return this.delegate.get(key);
    }

    public char getIfAbsent(float key, char ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public char getOrThrow(float key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(float key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(char value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatCharProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<FloatCharPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableFloatCharMap select(FloatCharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatCharMap reject(FloatCharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableFloatCharMap toImmutable() {
        return this;
    }

    public CharIterator charIterator() {
        return new UnmodifiableCharIterator((CharIterator)this.delegate.charIterator());
    }

    public void forEach(CharProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(CharPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableCharCollection select(CharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public char max() {
        return this.delegate.max();
    }

    public char maxIfEmpty(char defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public char min() {
        return this.delegate.min();
    }

    public char minIfEmpty(char defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableCharList toSortedList() {
        return this.delegate.toSortedList();
    }

    public char[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(char value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableCharList toList() {
        return this.delegate.toList();
    }

    public MutableCharSet toSet() {
        return this.delegate.toSet();
    }

    public MutableCharBag toBag() {
        return this.delegate.toBag();
    }

    public LazyCharIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableFloatCharMap newWithKeyValue(float key, char value) {
        FloatCharHashMap map = new FloatCharHashMap(this.size() + 1);
        map.putAll((FloatCharMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableFloatCharMap newWithoutKey(float key) {
        FloatCharHashMap map = new FloatCharHashMap(this.size());
        map.putAll((FloatCharMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableFloatCharMap newWithoutAllKeys(FloatIterable keys) {
        FloatCharHashMap map = new FloatCharHashMap(this.size());
        map.putAll((FloatCharMap)this);
        FloatIterator iterator = keys.floatIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(this.delegate.keySet());
    }

    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableFloatCharMapSerializationProxy((FloatCharMap)this);
    }

    protected static class ImmutableFloatCharMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private FloatCharMap map;

        public ImmutableFloatCharMapSerializationProxy() {
        }

        protected ImmutableFloatCharMapSerializationProxy(FloatCharMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((FloatCharProcedure)new CheckedFloatCharProcedure(){

                    public void safeValue(float key, char value) throws IOException {
                        out.writeFloat(key);
                        out.writeChar(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            FloatCharHashMap deserializedMap = new FloatCharHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readFloat(), in.readChar());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

