/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.util.Arrays;

public abstract class AbstractDoubleIterable
implements DoubleIterable {
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public double minIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList(this).sortThis();
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList(this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet(this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag(this);
    }

    public boolean containsAll(double ... source) {
        for (double item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.allSatisfy(new DoublePredicate(){

            public boolean accept(double each) {
                return AbstractDoubleIterable.this.contains(each);
            }
        });
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }
}

