/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.bag.primitive.MutableLongBagFactory;
import com.gs.collections.api.bag.primitive.MutableLongBag;

/**
 * MutableLongBagFactoryImpl is a factory implementation which creates instances of type {@link MutableLongBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableLongBagFactoryImpl implements MutableLongBagFactory
{
    public MutableLongBag empty()
    {
        return new LongHashBag();
    }

    public MutableLongBag of()
    {
        return this.empty();
    }

    public MutableLongBag with()
    {
        return this.empty();
    }

    public MutableLongBag of(long... items)
    {
        return this.with(items);
    }

    public MutableLongBag with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return LongHashBag.newBagWith(items);
    }

    public MutableLongBag ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public MutableLongBag withAll(LongIterable items)
    {
        return LongHashBag.newBag(items);
    }
}
