/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.collection.mutable.primitive;

import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import net.jcip.annotations.ThreadSafe;

/**
 * This file was automatically generated from template file synchronizedPrimitiveCollection.stg.
 *
 * @since 4.0.
 */
@ThreadSafe
public class SynchronizedDoubleCollection
        extends AbstractSynchronizedDoubleCollection
{
    private static final long serialVersionUID = 1L;

    protected SynchronizedDoubleCollection(MutableDoubleCollection collection)
    {
        this(collection, null);
    }

    protected SynchronizedDoubleCollection(MutableDoubleCollection collection, Object newLock)
    {
        super(collection, newLock);
    }

    /**
     * This method will take a MutableDoubleCollection and wrap it directly in a SynchronizedDoubleCollection.
     */
    public static SynchronizedDoubleCollection of(MutableDoubleCollection collection)
    {
        return new SynchronizedDoubleCollection(collection);
    }

    /**
     * This method will take a MutableDoubleCollection and wrap it directly in a SynchronizedDoubleCollection.
     * Additionally, a developer specifies which lock to use with the collection.
     */
    public static SynchronizedDoubleCollection of(MutableDoubleCollection collection, Object lock)
    {
        return new SynchronizedDoubleCollection(collection, lock);
    }
}
