/*
 * Copyright 2015 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains static utilities for creating mutable and immutable collection factories.
 *
 * @see com.gs.collections.impl.factory.Lists for creating Lists
 * @see com.gs.collections.impl.factory.Sets for creating Sets
 * @see com.gs.collections.impl.factory.SortedSets for creating SortedSets
 * @see com.gs.collections.impl.factory.Bags for creating Bags
 * @see com.gs.collections.impl.factory.Stacks for creating Stacks
 * @see com.gs.collections.impl.factory.Maps for creating Maps
 * @see com.gs.collections.impl.factory.SortedMaps for creating SortedMaps
 * @see com.gs.collections.impl.factory.BiMaps for creating BiMaps
 * @see com.gs.collections.impl.factory.Multimaps for creating Multimaps
 * @see com.gs.collections.impl.factory.HashingStrategySets for creating Sets with HashingStrategy
 * @see com.gs.collections.impl.factory.HashingStrategyMaps for creating Maps with HashingStrategy
 * @see com.gs.collections.impl.factory.Iterables for static import friendly shortcuts for creating Lists, Sets, Bags and Maps
 */
package com.gs.collections.impl.factory;
