/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableByteIntMapFactory;
import com.gs.collections.api.map.primitive.ImmutableByteIntMap;
import com.gs.collections.api.map.primitive.ByteIntMap;

/**
 * ImmutableByteIntMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteIntMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteIntMapFactoryImpl implements ImmutableByteIntMapFactory
{
    public ImmutableByteIntMap empty()
    {
        return ImmutableByteIntEmptyMap.INSTANCE;
    }

    public ImmutableByteIntMap of()
    {
        return this.empty();
    }

    public ImmutableByteIntMap with()
    {
        return this.empty();
    }

    public ImmutableByteIntMap of(byte key, int value)
    {
        return this.with(key, value);
    }

    public ImmutableByteIntMap with(byte key, int value)
    {
        return new ImmutableByteIntSingletonMap(key, value);
    }

    public ImmutableByteIntMap ofAll(ByteIntMap map)
    {
        return this.withAll(map);
    }

    public ImmutableByteIntMap withAll(ByteIntMap map)
    {
        if (map instanceof ImmutableByteIntMap)
        {
            return (ImmutableByteIntMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteIntSingletonMap(key, map.get(key));
        }
        return new ImmutableByteIntHashMap(map);
    }
}
