/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableFloatByteMapFactory;
import com.gs.collections.api.map.primitive.ImmutableFloatByteMap;
import com.gs.collections.api.map.primitive.FloatByteMap;

/**
 * ImmutableFloatByteMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatByteMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatByteMapFactoryImpl implements ImmutableFloatByteMapFactory
{
    public ImmutableFloatByteMap empty()
    {
        return ImmutableFloatByteEmptyMap.INSTANCE;
    }

    public ImmutableFloatByteMap of()
    {
        return this.empty();
    }

    public ImmutableFloatByteMap with()
    {
        return this.empty();
    }

    public ImmutableFloatByteMap of(float key, byte value)
    {
        return this.with(key, value);
    }

    public ImmutableFloatByteMap with(float key, byte value)
    {
        return new ImmutableFloatByteSingletonMap(key, value);
    }

    public ImmutableFloatByteMap ofAll(FloatByteMap map)
    {
        return this.withAll(map);
    }

    public ImmutableFloatByteMap withAll(FloatByteMap map)
    {
        if (map instanceof ImmutableFloatByteMap)
        {
            return (ImmutableFloatByteMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            float key = map.keysView().floatIterator().next();
            return new ImmutableFloatByteSingletonMap(key, map.get(key));
        }
        return new ImmutableFloatByteHashMap(map);
    }
}
