/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableLongLongMapFactory;
import com.gs.collections.api.map.primitive.ImmutableLongLongMap;
import com.gs.collections.api.map.primitive.LongLongMap;

/**
 * ImmutableLongLongMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongLongMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongLongMapFactoryImpl implements ImmutableLongLongMapFactory
{
    public ImmutableLongLongMap empty()
    {
        return ImmutableLongLongEmptyMap.INSTANCE;
    }

    public ImmutableLongLongMap of()
    {
        return this.empty();
    }

    public ImmutableLongLongMap with()
    {
        return this.empty();
    }

    public ImmutableLongLongMap of(long key, long value)
    {
        return this.with(key, value);
    }

    public ImmutableLongLongMap with(long key, long value)
    {
        return new ImmutableLongLongSingletonMap(key, value);
    }

    public ImmutableLongLongMap ofAll(LongLongMap map)
    {
        return this.withAll(map);
    }

    public ImmutableLongLongMap withAll(LongLongMap map)
    {
        if (map instanceof ImmutableLongLongMap)
        {
            return (ImmutableLongLongMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongLongSingletonMap(key, map.get(key));
        }
        return new ImmutableLongLongHashMap(map);
    }
}
