/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.util.Collections;
import java.io.Serializable;
import java.util.Set;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectDoublePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectDoubleProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.MutableDoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.ImmutableObjectDoubleMap;
import com.gs.collections.api.map.primitive.MutableObjectDoubleMap;
import com.gs.collections.api.map.primitive.ObjectDoubleMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.ObjectDoublePair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.primitive.ObjectDoubleMaps;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;

/**
 * This file was automatically generated from template file unmodifiableObjectPrimitiveMap.stg.
 *
 * @since 3.2
 */
public final class UnmodifiableObjectDoubleMap<K>
        implements MutableObjectDoubleMap<K>, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectDoubleMap<K> map;

    UnmodifiableObjectDoubleMap(MutableObjectDoubleMap<K> map)
    {
        this.map = map;
    }

    private boolean isAbsent(double result, K key)
    {
        return result == ObjectDoubleHashMap.EMPTY_VALUE && !this.containsKey(key);
    }

    private double getIfAbsentThrow(K key)
    {
        double result = this.map.get(key);
        if (this.isAbsent(result, key))
        {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(K key, double value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ObjectDoubleMap<? extends K> map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(K key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(Object key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public double removeKeyIfAbsent(K key, double value)
    {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    public double getIfAbsentPut(K key, double value)
    {
        return this.getIfAbsentThrow(key);
    }

    public double getIfAbsentPut(K key, DoubleFunction0 function)
    {
        return this.getIfAbsentThrow(key);
    }

    public double getIfAbsentPutWithKey(K key, DoubleFunction<? super K> function)
    {
        return this.getIfAbsentThrow(key);
    }

    public <P> double getIfAbsentPutWith(K key, DoubleFunction<? super P> function, P parameter)
    {
        return this.getIfAbsentThrow(key);
    }

    public double updateValue(K key, double initialValueIfAbsent, DoubleToDoubleFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public double addToValue(K key, double toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public double get(Object key)
    {
        return this.map.get(key);
    }

    public double getOrThrow(Object key)
    {
        return this.map.getOrThrow(key);
    }

    public double getIfAbsent(Object key, double ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(double value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectDoubleProcedure<? super K> procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public MutableObjectDoubleMap<K> select(ObjectDoublePredicate<? super K> predicate)
    {
        return this.map.select(predicate);
    }

    public MutableObjectDoubleMap<K> reject(ObjectDoublePredicate<? super K> predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableDoubleIterator doubleIterator()
    {
        return new UnmodifiableDoubleIterator(this.map.doubleIterator());
    }

    public void forEach(DoubleProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(DoublePredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableDoubleCollection select(DoublePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableDoubleCollection reject(DoublePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V1> MutableCollection<V1> collect(DoubleToObjectFunction<? extends V1> function)
    {
        return this.map.collect(function);
    }

    public double sum()
    {
        return this.map.sum();
    }

    public double max()
    {
        return this.map.max();
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public double min()
    {
        return this.map.min();
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public double[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableDoubleList toSortedList()
    {
        return this.map.toSortedList();
    }

    public double[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(double value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(double... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableDoubleList toList()
    {
        return this.map.toList();
    }

    public MutableDoubleSet toSet()
    {
        return this.map.toSet();
    }

    public MutableDoubleBag toBag()
    {
        return this.map.toBag();
    }

    public LazyDoubleIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableObjectDoubleMap<K> withKeyValue(K key, double value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableObjectDoubleMap<K> withoutKey(K key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableObjectDoubleMap<K> withoutAllKeys(Iterable<? extends K> keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableObjectDoubleMap<K> asUnmodifiable()
    {
        return this;
    }

    public MutableObjectDoubleMap<K> asSynchronized()
    {
        return new SynchronizedObjectDoubleMap<K>(this);
    }

    public ImmutableObjectDoubleMap<K> toImmutable()
    {
        return ObjectDoubleMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public Set<K> keySet()
    {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public MutableDoubleCollection values()
    {
        return UnmodifiableDoubleCollection.of(this.map.values());
    }

    public LazyIterable<K> keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<ObjectDoublePair<K>> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
