/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.set.primitive.MutableDoubleSetFactory;
import com.gs.collections.api.set.primitive.MutableDoubleSet;

/**
 * MutableDoubleSetFactoryImpl is a factory implementation which creates instances of type {@link MutableDoubleSet}.
 * This file was automatically generated from template file mutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableDoubleSetFactoryImpl implements MutableDoubleSetFactory
{
    public MutableDoubleSet empty()
    {
        return new DoubleHashSet();
    }

    public MutableDoubleSet of()
    {
        return this.empty();
    }

    public MutableDoubleSet with()
    {
        return this.empty();
    }

    public MutableDoubleSet of(double... items)
    {
        return this.with(items);
    }

    public MutableDoubleSet with(double... items)
    {
        if (items == null || items.length == 0)
        {
            return this.empty();
        }
        return DoubleHashSet.newSetWith(items);
    }

    public MutableDoubleSet ofAll(DoubleIterable items)
    {
        return this.withAll(items);
    }

    public MutableDoubleSet withAll(DoubleIterable items)
    {
        return DoubleHashSet.newSet(items);
    }
}
