/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.ByteList;
import com.gs.collections.api.list.primitive.ImmutableByteList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.iterator.ImmutableEmptyByteIterator;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseByteIterable;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableByteEmptyList
implements ImmutableByteList,
Serializable {
    static final ImmutableByteList INSTANCE = new ImmutableByteEmptyList();
    private static final long serialVersionUID = 1L;

    ImmutableByteEmptyList() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public byte get(int index) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    public byte getFirst() {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public byte getLast() {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public int indexOf(byte value) {
        return -1;
    }

    public int lastIndexOf(byte value) {
        return -1;
    }

    public ByteIterator byteIterator() {
        return ImmutableEmptyByteIterator.INSTANCE;
    }

    public void forEach(ByteProcedure procedure) {
    }

    public void forEachWithIndex(ByteIntProcedure procedure) {
    }

    public int count(BytePredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return true;
    }

    public ImmutableByteList select(BytePredicate predicate) {
        return this;
    }

    public ImmutableByteList reject(BytePredicate predicate) {
        return this;
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return ifNone;
    }

    public <V> ImmutableList<V> collect(ByteToObjectFunction<? extends V> function) {
        return Lists.immutable.of();
    }

    public long sum() {
        return 0L;
    }

    public byte max() {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return defaultValue;
    }

    public byte min() {
        throw new NoSuchElementException();
    }

    public byte minIfEmpty(byte defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray() {
        return new byte[0];
    }

    public MutableByteList toSortedList() {
        return new ByteArrayList();
    }

    public long dotProduct(ByteList list) {
        if (!list.isEmpty()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return 0L;
    }

    public byte[] toArray() {
        return new byte[0];
    }

    public boolean contains(byte value) {
        return false;
    }

    public boolean containsAll(byte ... source) {
        return source.length == 0;
    }

    public boolean containsAll(ByteIterable source) {
        return source.isEmpty();
    }

    public LazyByteIterable asReversed() {
        return ReverseByteIterable.adapt((ByteList)this);
    }

    public MutableByteList toList() {
        return new ByteArrayList();
    }

    public MutableByteSet toSet() {
        return new ByteHashSet();
    }

    public MutableByteBag toBag() {
        return new ByteHashBag();
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public ImmutableByteList toImmutable() {
        return this;
    }

    public ImmutableByteEmptyList toReversed() {
        return this;
    }

    public ImmutableByteList newWith(byte element) {
        return ByteLists.immutable.with(element);
    }

    public ImmutableByteList newWithout(byte element) {
        return this;
    }

    public ImmutableByteList newWithAll(ByteIterable elements) {
        return ByteLists.immutable.withAll(elements);
    }

    public ImmutableByteList newWithoutAll(ByteIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectByteIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof ByteList)) {
            return false;
        }
        ByteList list = (ByteList)otherList;
        return list.isEmpty();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableByteList distinct() {
        return INSTANCE;
    }

    public ImmutableByteList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

