/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableShortStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableShortStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableShortArrayStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableShortEmptyStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableShortSingletonStack;

public class ImmutableShortStackFactoryImpl
implements ImmutableShortStackFactory {
    public ImmutableShortStack empty() {
        return ImmutableShortEmptyStack.INSTANCE;
    }

    public ImmutableShortStack of() {
        return this.empty();
    }

    public ImmutableShortStack with() {
        return this.empty();
    }

    public ImmutableShortStack of(short one) {
        return this.with(one);
    }

    public ImmutableShortStack with(short one) {
        return new ImmutableShortSingletonStack(one);
    }

    public ImmutableShortStack of(short ... items) {
        return this.with(items);
    }

    public ImmutableShortStack with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableShortArrayStack.newStackWith(items);
    }

    public ImmutableShortStack ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public ImmutableShortStack withAll(ShortIterable items) {
        if (items instanceof ImmutableShortStack) {
            return (ImmutableShortStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableShortStack ofAllReversed(ShortIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableShortStack withAllReversed(ShortIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableShortArrayStack.newStackFromTopToBottom(items);
    }
}

