/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.tuple.primitive;

import com.gs.collections.api.tuple.primitive.CharFloatPair;

public class CharFloatPairImpl
implements CharFloatPair {
    private static final long serialVersionUID = 1L;
    private final char one;
    private final float two;

    CharFloatPairImpl(char newOne, float newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    public char getOne() {
        return this.one;
    }

    public float getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharFloatPair)) {
            return false;
        }
        CharFloatPair that = (CharFloatPair)o;
        return this.one == that.getOne() && Float.compare(this.two, that.getTwo()) == 0;
    }

    public int hashCode() {
        return 29 * this.one + Float.floatToIntBits(this.two);
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    public int compareTo(CharFloatPair that) {
        int i = this.one - that.getOne();
        if (i != 0) {
            return i;
        }
        return Float.compare(this.two, that.getTwo());
    }
}

