/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.tuple.primitive;

import com.gs.collections.api.tuple.primitive.ObjectFloatPair;
import com.gs.collections.impl.block.factory.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFloatPairImpl<T>
implements ObjectFloatPair<T> {
    private static final long serialVersionUID = 1L;
    private final T one;
    private final float two;

    ObjectFloatPairImpl(T newOne, float newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    public T getOne() {
        return this.one;
    }

    public float getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectFloatPair)) {
            return false;
        }
        ObjectFloatPair that = (ObjectFloatPair)o;
        return Comparators.nullSafeEquals(this.one, that.getOne()) && Float.compare(this.two, that.getTwo()) == 0;
    }

    public int hashCode() {
        int result = this.one == null ? 0 : this.one.hashCode();
        result = 29 * result + Float.floatToIntBits(this.two);
        return result;
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    public int compareTo(ObjectFloatPair<T> that) {
        int i = ((Comparable)this.one).compareTo(that.getOne());
        if (i != 0) {
            return i;
        }
        return Float.compare(this.two, that.getTwo());
    }
}

