/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http.javanet;

import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

@Beta
public class MockHttpURLConnection
extends HttpURLConnection {
    private boolean doOutputCalled;
    private OutputStream outputStream = new ByteArrayOutputStream(0);
    public static final byte[] INPUT_BUF = new byte[1];
    public static final byte[] ERROR_BUF = new byte[5];
    private InputStream inputStream = new ByteArrayInputStream(INPUT_BUF);
    private InputStream errorStream = new ByteArrayInputStream(ERROR_BUF);

    public MockHttpURLConnection(URL u) {
        super(u);
    }

    public void disconnect() {
    }

    public boolean usingProxy() {
        return false;
    }

    public void connect() throws IOException {
    }

    public int getResponseCode() throws IOException {
        return this.responseCode;
    }

    public void setDoOutput(boolean dooutput) {
        this.doOutputCalled = true;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        return super.getOutputStream();
    }

    public final boolean doOutputCalled() {
        return this.doOutputCalled;
    }

    public MockHttpURLConnection setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public MockHttpURLConnection setResponseCode(int responseCode) {
        Preconditions.checkArgument(responseCode >= -1);
        this.responseCode = responseCode;
        return this;
    }

    public InputStream getInputStream() throws IOException {
        if (this.responseCode < 400) {
            return this.inputStream;
        }
        throw new IOException();
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }
}

