/*
 * Decompiled with CFR 0.152.
 */
package jaitools.numeric;

import jaitools.numeric.AbstractProcessor;
import jaitools.numeric.Statistic;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumProcessor
extends AbstractProcessor {
    private static final Set<Statistic> SUPPORTED = Collections.singleton(Statistic.SUM);
    Double sum = 0.0;

    @Override
    public Collection<Statistic> getSupported() {
        return SUPPORTED;
    }

    @Override
    protected boolean update(Double sample) {
        if (this.isAccepted(sample)) {
            this.sum = this.sum + sample;
            return true;
        }
        return false;
    }

    @Override
    public Double get(Statistic stat) {
        if (this.getNumAccepted() == 0L) {
            return Double.NaN;
        }
        switch (stat) {
            case SUM: {
                return this.sum;
            }
        }
        throw new IllegalArgumentException((Object)((Object)stat) + " not supported by " + this.getClass().getName());
    }
}

