/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import com.hierynomus.sshj.userauth.certificate.Certificate;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignature;
import net.schmizz.sshj.signature.Signature;

public class SignatureRSA
extends AbstractSignature {
    private String keyTypeName;

    public SignatureRSA(String keyTypeName) {
        super("SHA1withRSA");
        this.keyTypeName = keyTypeName;
    }

    @Override
    public void initVerify(PublicKey publicKey) {
        try {
            if (this.keyTypeName.equals(KeyType.RSA_CERT.toString()) && publicKey instanceof Certificate) {
                this.signature.initVerify((PublicKey)((Certificate)publicKey).getKey());
            } else {
                this.signature.initVerify(publicKey);
            }
        }
        catch (InvalidKeyException e) {
            throw new SSHRuntimeException(e);
        }
    }

    @Override
    public byte[] encode(byte[] signature) {
        return signature;
    }

    @Override
    public boolean verify(byte[] sig) {
        sig = this.extractSig(sig, KeyType.RSA.toString());
        try {
            return this.signature.verify(sig);
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public static class FactoryCERT
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureRSA(KeyType.RSA_CERT.toString());
        }

        @Override
        public String getName() {
            return KeyType.RSA_CERT.toString();
        }
    }

    public static class Factory
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureRSA(KeyType.RSA.toString());
        }

        @Override
        public String getName() {
            return KeyType.RSA.toString();
        }
    }
}

