/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.io.util.CliCommandUtil;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.regex.Pattern;

public class GhostscriptHelper {
    public static final String GHOSTSCRIPT_ENVIRONMENT_VARIABLE = "ITEXT_GS_EXEC";
    @Deprecated
    static final String GHOSTSCRIPT_ENVIRONMENT_VARIABLE_LEGACY = "gsExec";
    static final String GHOSTSCRIPT_KEYWORD = "GPL Ghostscript";
    private static final String TEMP_FILE_PREFIX = "itext_gs_io_temp";
    private static final String RENDERED_IMAGE_EXTENSION = "png";
    private static final String GHOSTSCRIPT_PARAMS = " -dSAFER -dNOPAUSE -dBATCH -sDEVICE=png16m -r150 {0} -sOutputFile=\"{1}\" \"{2}\"";
    private static final String PAGE_NUMBER_PATTERN = "%03d";
    private static final Pattern PAGE_LIST_REGEX = Pattern.compile("^(\\d+,)*\\d+$");
    private String gsExec;

    public GhostscriptHelper() {
        this(null);
    }

    public GhostscriptHelper(String newGsExec) {
        this.gsExec = newGsExec;
        if (this.gsExec == null) {
            this.gsExec = SystemUtil.getPropertyOrEnvironmentVariable((String)GHOSTSCRIPT_ENVIRONMENT_VARIABLE);
            if (this.gsExec == null) {
                this.gsExec = SystemUtil.getPropertyOrEnvironmentVariable((String)GHOSTSCRIPT_ENVIRONMENT_VARIABLE_LEGACY);
            }
        }
        if (!CliCommandUtil.isVersionCommandExecutable(this.gsExec, GHOSTSCRIPT_KEYWORD)) {
            throw new IllegalArgumentException("Ghostscript command is not specified or specified incorrectly. Set the ITEXT_GS_EXEC environment variable to a CLI command that can run the Ghostscript application. See BUILDING.MD in the root of the repository for more details.");
        }
    }

    public String getCliExecutionCommand() {
        return this.gsExec;
    }

    public void runGhostScriptImageGeneration(String pdf, String outDir, String image) throws IOException, InterruptedException {
        this.runGhostScriptImageGeneration(pdf, outDir, image, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runGhostScriptImageGeneration(String pdf, String outDir, String image, String pageList) throws IOException, InterruptedException {
        String replacementImagesDirectory;
        String replacementPdf;
        block9: {
            if (!FileUtil.directoryExists((String)outDir)) {
                throw new IllegalArgumentException("Cannot open output directory for <filename>".replace("<filename>", pdf));
            }
            if (!GhostscriptHelper.validateImageFilePattern(image)) {
                throw new IllegalArgumentException("Invalid output image pattern: " + image);
            }
            if (!GhostscriptHelper.validatePageList(pageList)) {
                throw new IllegalArgumentException("Invalid page list: " + pageList);
            }
            String formattedPageList = pageList == null ? "" : "-sPageList=<pagelist>".replace("<pagelist>", pageList);
            replacementPdf = null;
            replacementImagesDirectory = null;
            String[] temporaryOutputImages = null;
            try {
                replacementPdf = FileUtil.createTempCopy((String)pdf, (String)TEMP_FILE_PREFIX, null);
                replacementImagesDirectory = FileUtil.createTempDirectory((String)TEMP_FILE_PREFIX);
                String currGsParams = MessageFormatUtil.format((String)GHOSTSCRIPT_PARAMS, (Object[])new Object[]{formattedPageList, Paths.get(replacementImagesDirectory, "itext_gs_io_temp%03d.png").toString(), replacementPdf});
                if (!SystemUtil.runProcessAndWait((String)this.gsExec, (String)currGsParams)) {
                    temporaryOutputImages = FileUtil.listFilesInDirectory((String)replacementImagesDirectory, (boolean)false);
                    throw new GhostscriptExecutionException("GhostScript failed for <filename>".replace("<filename>", pdf));
                }
                temporaryOutputImages = FileUtil.listFilesInDirectory((String)replacementImagesDirectory, (boolean)false);
                if (null != temporaryOutputImages) {
                    for (int i = 0; i < temporaryOutputImages.length; ++i) {
                        FileUtil.copy((String)temporaryOutputImages[i], (String)Paths.get(outDir, image + "-" + GhostscriptHelper.formatImageNumber(i + 1) + "." + RENDERED_IMAGE_EXTENSION).toString());
                    }
                }
                if (null == temporaryOutputImages) break block9;
            }
            catch (Throwable throwable) {
                if (null != temporaryOutputImages) {
                    FileUtil.removeFiles(temporaryOutputImages);
                }
                FileUtil.removeFiles((String[])new String[]{replacementImagesDirectory, replacementPdf});
                throw throwable;
            }
            FileUtil.removeFiles((String[])temporaryOutputImages);
        }
        FileUtil.removeFiles((String[])new String[]{replacementImagesDirectory, replacementPdf});
    }

    static boolean validatePageList(String pageList) {
        return null == pageList || PAGE_LIST_REGEX.matcher(pageList).matches();
    }

    static boolean validateImageFilePattern(String imageFilePattern) {
        return null != imageFilePattern && !imageFilePattern.trim().isEmpty() && !imageFilePattern.contains("%");
    }

    static String formatImageNumber(int pageNumber) {
        StringBuilder stringBuilder = new StringBuilder();
        int zeroFiller = pageNumber;
        while (0 == zeroFiller / 100) {
            stringBuilder.append('0');
            zeroFiller *= 10;
        }
        stringBuilder.append(pageNumber);
        return stringBuilder.toString();
    }

    public static class GhostscriptExecutionException
    extends RuntimeException {
        public GhostscriptExecutionException(String msg) {
            super(msg);
        }
    }
}

