/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridj.BridJ;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.ann.Convention;
import org.bridj.ann.Library;
import org.bridj.ann.Optional;
import org.bridj.ann.Ptr;
import org.bridj.util.ProcessUtils;
import org.bridj.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCL {
    static final boolean debug = "true".equals(System.getProperty("javacl.debug")) || "1".equals(System.getenv("JAVACL_DEBUG"));
    static final boolean verbose = debug || "true".equals(System.getProperty("javacl.verbose")) || "1".equals(System.getenv("JAVACL_VERBOSE"));
    static final int minLogLevel = Level.WARNING.intValue();
    static final String JAVACL_DEBUG_COMPILER_FLAGS_PROP = "JAVACL_DEBUG_COMPILER_FLAGS";
    static List<String> DEBUG_COMPILER_FLAGS;
    static final OpenCLLibrary CL;
    static File userJavaCLDir;
    static File userCacheDir;

    static boolean shouldLog(Level level) {
        return verbose || level.intValue() >= minLogLevel;
    }

    static boolean log(Level level, String message, Throwable ex) {
        if (!JavaCL.shouldLog(level)) {
            return true;
        }
        Logger.getLogger(JavaCL.class.getSimpleName()).log(level, message, ex);
        return true;
    }

    static boolean log(Level level, String message) {
        JavaCL.log(level, message, null);
        return true;
    }

    private static int getPlatformIDs(int count, Pointer<OpenCLLibrary.cl_platform_id> out, Pointer<Integer> pCount) {
        try {
            return CL.clIcdGetPlatformIDsKHR(count, Pointer.getPeer(out), Pointer.getPeer(pCount));
        }
        catch (Throwable th) {
            return CL.clGetPlatformIDs(count, Pointer.getPeer(out), Pointer.getPeer(pCount));
        }
    }

    public static CLPlatform[] listGPUPoweredPlatforms() {
        CLPlatform[] platforms = JavaCL.listPlatforms();
        ArrayList<CLPlatform> out = new ArrayList<CLPlatform>(platforms.length);
        for (CLPlatform platform : platforms) {
            if (platform.listGPUDevices(true).length <= 0) continue;
            out.add(platform);
        }
        return out.toArray(new CLPlatform[out.size()]);
    }

    public static CLPlatform[] listPlatforms() {
        Pointer<Integer> pCount = Pointer.allocateInt();
        CLException.error(JavaCL.getPlatformIDs(0, null, pCount));
        int nPlats = pCount.getInt();
        if (nPlats == 0) {
            return new CLPlatform[0];
        }
        Pointer<OpenCLLibrary.cl_platform_id> ids = Pointer.allocateTypedPointers(OpenCLLibrary.cl_platform_id.class, nPlats);
        CLException.error(JavaCL.getPlatformIDs(nPlats, ids, null));
        CLPlatform[] platforms = new CLPlatform[nPlats];
        for (int i = 0; i < nPlats; ++i) {
            platforms[i] = new CLPlatform(ids.getSizeTAtIndex(i));
        }
        return platforms;
    }

    public static CLContext createContext(Map<CLPlatform.ContextProperties, Object> contextProperties, CLDevice ... devices) {
        return devices[0].getPlatform().createContext(contextProperties, devices);
    }

    public static void unloadCompiler() {
        CLException.error(CL.clUnloadCompiler());
    }

    public static CLDevice getBestDevice() {
        return JavaCL.getBestDevice(CLPlatform.DeviceFeature.MaxComputeUnits);
    }

    public static CLDevice getBestDevice(CLPlatform.DeviceFeature ... preferredFeatures) {
        ArrayList<CLDevice> devices = new ArrayList<CLDevice>();
        for (CLPlatform platform : JavaCL.listPlatforms()) {
            devices.addAll(Arrays.asList(platform.listAllDevices(true)));
        }
        return CLPlatform.getBestDevice(Arrays.asList(preferredFeatures), devices);
    }

    public static CLContext createBestContext() {
        return JavaCL.createBestContext(CLPlatform.DeviceFeature.MaxComputeUnits);
    }

    public static CLContext createBestContext(CLPlatform.DeviceFeature ... preferredFeatures) {
        CLDevice device = JavaCL.getBestDevice(preferredFeatures);
        return device.getPlatform().createContext(null, device);
    }

    public static CLContext createContextFromCurrentGL() {
        RuntimeException first = null;
        for (CLPlatform platform : JavaCL.listPlatforms()) {
            try {
                CLContext ctx = platform.createContextFromCurrentGL();
                if (ctx == null) continue;
                return ctx;
            }
            catch (RuntimeException ex) {
                if (first != null) continue;
                first = ex;
            }
        }
        throw new RuntimeException("Failed to create an OpenCL context based on the current OpenGL context", first);
    }

    static synchronized File createTempFile(String prefix, String suffix, String category) {
        File dir = new File(userJavaCLDir, category);
        dir.mkdirs();
        try {
            return File.createTempFile(prefix, suffix, dir);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create a temporary directory for category '" + category + "' in " + userJavaCLDir + ": " + ex.getMessage(), ex);
        }
    }

    static synchronized File createTempDirectory(String prefix, String suffix, String category) {
        File file = JavaCL.createTempFile(prefix, suffix, category);
        file.delete();
        file.mkdir();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if (Platform.isLinux()) {
            String amdAppBase = "/opt/AMDAPP/lib";
            BridJ.addLibraryPath(amdAppBase + "/" + (Platform.is64Bits() ? "x86_64" : "x86"));
            BridJ.addLibraryPath(amdAppBase);
        }
        boolean needsAdditionalSynchronization = false;
        OpenCLProbeLibrary probe = null;
        try {
            block19: {
                block22: {
                    String alt;
                    block21: {
                        block20: {
                            try {
                                BridJ.setNativeLibraryActualName("OpenCLProbe", "OpenCL");
                                BridJ.register();
                            }
                            catch (Throwable th) {
                                // empty catch block
                            }
                            probe = new OpenCLProbeLibrary();
                            if (probe.isValid()) break block19;
                            BridJ.unregister(OpenCLProbeLibrary.class);
                            if (!Platform.is64Bits()) break block20;
                            alt = "atiocl64";
                            if (BridJ.getNativeLibraryFile("atiocl64") != null) break block21;
                            alt = "amdocl64";
                            if (BridJ.getNativeLibraryFile("amdocl64") != null) break block21;
                        }
                        alt = "atiocl32";
                        if (BridJ.getNativeLibraryFile("atiocl32") != null) break block21;
                        alt = "atiocl";
                        if (BridJ.getNativeLibraryFile("atiocl") != null) break block21;
                        alt = "amdocl32";
                        if (BridJ.getNativeLibraryFile("amdocl32") != null) break block21;
                        alt = "amdocl";
                        if (BridJ.getNativeLibraryFile("amdocl") == null) break block22;
                    }
                    JavaCL.log(Level.INFO, "Hacking around ATI's weird driver bugs (using atiocl/amdocl library instead of OpenCL)", null);
                    BridJ.setNativeLibraryActualName("OpenCL", alt);
                }
                BridJ.register(OpenCLProbeLibrary.class);
            }
            if (probe.hasOpenCL1_0()) {
                needsAdditionalSynchronization = true;
                JavaCL.log(Level.WARNING, "At least one OpenCL platform uses OpenCL 1.0, which is not thread-safe: will use (slower) synchronized low-level bindings.");
            }
        }
        finally {
            if (probe != null) {
                BridJ.unregister(OpenCLProbeLibrary.class);
            }
            probe = null;
        }
        if (debug) {
            String debugArgs = System.getenv(JAVACL_DEBUG_COMPILER_FLAGS_PROP);
            DEBUG_COMPILER_FLAGS = debugArgs != null ? Arrays.asList(debugArgs.split(" ")) : (Platform.isMacOSX() ? Arrays.asList("-g") : Arrays.asList("-O0", "-g"));
            int pid = ProcessUtils.getCurrentProcessId();
            JavaCL.log(Level.INFO, "Debug mode enabled with compiler flags \"" + StringUtils.implode(DEBUG_COMPILER_FLAGS, (Object)" ") + "\" (can be overridden with env. var. JAVACL_DEBUG_COMPILER_FLAGS_PROP)");
            JavaCL.log(Level.INFO, "You can debug your kernels with GDB using one of the following commands :\n\tsudo gdb --tui --pid=" + pid + "\n" + "\tsudo ddd --debugger \"gdb --pid=" + pid + "\"\n" + "More info here :\n" + "\thttp://code.google.com/p/javacl/wiki/DebuggingKernels");
        }
        Class<OpenCLLibrary> libraryClass = OpenCLLibrary.class;
        if (needsAdditionalSynchronization) {
            try {
                libraryClass = BridJ.subclassWithSynchronizedNativeMethods(libraryClass);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Failed to create a synchronized version of the OpenCL API bindings: " + ex, ex);
            }
        }
        BridJ.register(libraryClass);
        try {
            CL = (OpenCLLibrary)libraryClass.newInstance();
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to instantiate library " + libraryClass.getName() + ": " + ex, ex);
        }
        userJavaCLDir = new File(new File(System.getProperty("user.home")), ".javacl");
        userCacheDir = new File(userJavaCLDir, "cache");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Library(value="OpenCLProbe")
    @Convention(value=Convention.Style.StdCall)
    public static class OpenCLProbeLibrary {
        protected static CLInfoGetter infos = new CLInfoGetter(){

            @Override
            protected int getInfo(long entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
                return OpenCLProbeLibrary.clGetPlatformInfo(entity, infoTypeEnum, size, Pointer.getPeer(out), Pointer.getPeer(sizeOut));
            }
        };

        @Optional
        public static synchronized native int clGetPlatformIDs(int var0, Pointer<OpenCLLibrary.cl_platform_id> var1, Pointer<Integer> var2);

        @Optional
        public static synchronized native int clIcdGetPlatformIDsKHR(int var0, Pointer<OpenCLLibrary.cl_platform_id> var1, Pointer<Integer> var2);

        @Optional
        public static native int clGetPlatformInfo(@Ptr long var0, int var2, @Ptr long var3, @Ptr long var5, @Ptr long var7);

        private static int getPlatformIDs(int count, Pointer<OpenCLLibrary.cl_platform_id> out, Pointer<Integer> pCount) {
            try {
                return OpenCLProbeLibrary.clIcdGetPlatformIDsKHR(count, out, pCount);
            }
            catch (Throwable th) {
                return OpenCLProbeLibrary.clGetPlatformIDs(count, out, pCount);
            }
        }

        private static Pointer<OpenCLLibrary.cl_platform_id> getPlatformIDs() {
            Pointer<Integer> pCount = Pointer.allocateInt();
            CLException.error(OpenCLProbeLibrary.getPlatformIDs(0, null, pCount));
            int nPlats = pCount.getInt();
            if (nPlats == 0) {
                return null;
            }
            Pointer<OpenCLLibrary.cl_platform_id> ids = Pointer.allocateTypedPointers(OpenCLLibrary.cl_platform_id.class, nPlats);
            CLException.error(OpenCLProbeLibrary.getPlatformIDs(nPlats, ids, null));
            return ids;
        }

        public static boolean hasOpenCL1_0() {
            Pointer<OpenCLLibrary.cl_platform_id> ids = OpenCLProbeLibrary.getPlatformIDs();
            if (ids == null) {
                return false;
            }
            for (OpenCLLibrary.cl_platform_id id : ids) {
                if (!OpenCLProbeLibrary.isOpenCL1_0(id)) continue;
                return true;
            }
            return false;
        }

        public static boolean isOpenCL1_0(OpenCLLibrary.cl_platform_id platform) {
            String version = infos.getString(Pointer.getPeer(platform), 2305);
            return version.matches("OpenCL 1\\.0.*");
        }

        public static boolean isValid() {
            try {
                Pointer<OpenCLLibrary.cl_platform_id> ids = OpenCLProbeLibrary.getPlatformIDs();
                return ids != null;
            }
            catch (Throwable th) {
                return false;
            }
        }
    }
}

