/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.context;

import com.openhtmltopdf.css.extend.StylesheetFactory;
import com.openhtmltopdf.css.parser.CSSErrorHandler;
import com.openhtmltopdf.css.parser.CSSParser;
import com.openhtmltopdf.css.sheet.Ruleset;
import com.openhtmltopdf.css.sheet.Stylesheet;
import com.openhtmltopdf.css.sheet.StylesheetInfo;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.resource.CSSResource;
import com.openhtmltopdf.util.XRLog;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class StylesheetFactoryImpl
implements StylesheetFactory {
    private UserAgentCallback _userAgentCallback;
    private int _cacheCapacity = 16;
    private LinkedHashMap _cache = new LinkedHashMap(this._cacheCapacity, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > StylesheetFactoryImpl.this._cacheCapacity;
        }
    };
    private CSSParser _cssParser;

    public StylesheetFactoryImpl(UserAgentCallback userAgentCallback) {
        this._userAgentCallback = userAgentCallback;
        this._cssParser = new CSSParser(new CSSErrorHandler(){

            @Override
            public void error(String uri, String message) {
                XRLog.cssParse(Level.WARNING, "(" + uri + ") " + message);
            }
        });
    }

    @Override
    public synchronized Stylesheet parse(Reader reader, StylesheetInfo info) {
        try {
            return this._cssParser.parseStylesheet(info.getUri(), info.getOrigin(), reader);
        }
        catch (IOException e) {
            XRLog.cssParse(Level.WARNING, "Couldn't parse stylesheet at URI " + info.getUri() + ": " + e.getMessage(), e);
            e.printStackTrace();
            return new Stylesheet(info.getUri(), info.getOrigin());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stylesheet parse(StylesheetInfo info) {
        CSSResource cr = this._userAgentCallback.getCSSResource(info.getUri());
        if (cr == null) {
            return null;
        }
        Reader reader = cr.getResourceReader();
        if (reader == null) {
            return null;
        }
        try {
            Stylesheet stylesheet = this.parse(reader, info);
            return stylesheet;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public synchronized Ruleset parseStyleDeclaration(int origin, String styleDeclaration) {
        return this._cssParser.parseDeclaration(origin, styleDeclaration);
    }

    public synchronized void putStylesheet(Object key, Stylesheet sheet) {
        this._cache.put(key, sheet);
    }

    public synchronized boolean containsStylesheet(Object key) {
        return this._cache.containsKey(key);
    }

    public synchronized Stylesheet getCachedStylesheet(Object key) {
        return (Stylesheet)this._cache.get(key);
    }

    public synchronized Object removeCachedStylesheet(Object key) {
        return this._cache.remove(key);
    }

    public synchronized void flushCachedStylesheets() {
        this._cache.clear();
    }

    @Override
    public Stylesheet getStylesheet(StylesheetInfo info) {
        XRLog.load("Requesting stylesheet: " + info.getUri());
        Stylesheet s = this.getCachedStylesheet(info.getUri());
        if (s == null && !this.containsStylesheet(info.getUri())) {
            s = this.parse(info);
            this.putStylesheet(info.getUri(), s);
        }
        return s;
    }

    public void setUserAgentCallback(UserAgentCallback userAgent) {
        this._userAgentCallback = userAgent;
    }

    public void setSupportCMYKColors(boolean b) {
        this._cssParser.setSupportCMYKColors(b);
    }
}

