/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen.utils.support;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClassUtils {
    private static final Set<String> JAVA_LANG = Collections.singleton("java.lang");

    public static String getName(Class<?> cl) {
        return ClassUtils.getName(cl, JAVA_LANG, Collections.emptySet());
    }

    public static String getFullName(Class<?> cl) {
        if (cl.isArray()) {
            return ClassUtils.getFullName(cl.getComponentType()) + "[]";
        }
        String name = cl.getName();
        if (name.indexOf(36) > 0) {
            return ClassUtils.getFullName(cl.getDeclaringClass()) + "." + cl.getSimpleName();
        }
        return name;
    }

    public static String getPackageName(Class<?> cl) {
        while (cl.isArray()) {
            cl = cl.getComponentType();
        }
        String name = cl.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            return name.substring(0, i);
        }
        return "";
    }

    public static String getName(Class<?> cl, Set<String> packages, Set<String> classes) {
        if (cl.isArray()) {
            return ClassUtils.getName(cl.getComponentType(), packages, classes) + "[]";
        }
        String canonicalName = cl.getName().replace('$', '.');
        int i = cl.getName().lastIndexOf(46);
        if (classes.contains(canonicalName)) {
            return cl.getSimpleName();
        }
        if (cl.getEnclosingClass() != null) {
            return ClassUtils.getName(cl.getEnclosingClass(), packages, classes) + "." + cl.getSimpleName();
        }
        if (i == -1) {
            return canonicalName;
        }
        if (packages.contains(canonicalName.substring(0, i))) {
            return canonicalName.substring(i + 1);
        }
        return canonicalName;
    }

    public static Class<?> normalize(Class<?> clazz) {
        if (List.class.isAssignableFrom(clazz)) {
            return List.class;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return Set.class;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return Collection.class;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Map.class;
        }
        if (clazz.getName().contains("$$")) {
            Class<?> zuper = clazz.getSuperclass();
            if (zuper != null && !Object.class.equals(zuper)) {
                return zuper;
            }
        } else if (!Modifier.isPublic(clazz.getModifiers())) {
            return ClassUtils.normalize(clazz.getSuperclass());
        }
        return clazz;
    }

    private ClassUtils() {
    }
}

